/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import com.glaivestone.javax.lang.ConstantValue;
import com.glaivestone.javax.lang.ConstantValueWithDescription;
import com.glaivestone.mv.ApplicationModel;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.UISessionManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;

public class ToolServices {
    public static final Comparator<ConstantValueWithDescription<?>> BY_DESCRIPTION_CONSTANT_SORTER = new Comparator<ConstantValueWithDescription<?>>(){

        @Override
        public int compare(ConstantValueWithDescription<?> c1, ConstantValueWithDescription<?> c2) {
            return c1.description.compareTo(c2.description);
        }
    };
    public static final Comparator<ConstantValue<?>> BY_NAME_CONSTANT_SORTER = new Comparator<ConstantValue<?>>(){

        @Override
        public int compare(ConstantValue<?> c1, ConstantValue<?> c2) {
            return c1.name.compareTo(c2.name);
        }
    };
    public static final Comparator<RaceLocation> BY_FULLNAME_LOCATION_SORTER = new Comparator<RaceLocation>(){

        @Override
        public int compare(RaceLocation loc1, RaceLocation loc2) {
            return loc1.fullName.compareTo(loc2.fullName);
        }
    };
    public static ToolServices current;
    private List<RaceOrganization> raceOrganizersList;
    private List<CourseArrangement> courseArrangementsList;

    public static ToolServices getCurrent() {
        return current;
    }

    public static void initCurrent() {
        current = new ToolServices();
    }

    protected ToolServices() {
    }

    public List<CourseArrangement> constructCourseArrangementsList() {
        ArrayList<CourseArrangement> constantsList = new ArrayList<CourseArrangement>();
        for (CourseArrangement aConstant : CourseArrangement.values()) {
            constantsList.add(aConstant);
        }
        Collections.sort(constantsList, BY_NAME_CONSTANT_SORTER);
        return constantsList;
    }

    public <CT> List<CT> constructConstantList(Class<? extends ConstantValue<?>> constantClass) {
        ArrayList constantsList = new ArrayList();
        constantsList.addAll(ConstantValue.getConstantValues(constantClass));
        return constantsList;
    }

    public List<Class<? extends RaceClass<?>>> constructRaceClassClassesList(SeasonIdentifier season) {
        ArrayList availableClasses = new ArrayList();
        availableClasses.addAll(SeasonConfiguration.getSeasonConfig(season).getRaceClasses());
        return availableClasses;
    }

    public List<RaceOrganization> constructRaceOrganizersList() {
        ArrayList<RaceOrganization> aList = new ArrayList<RaceOrganization>();
        for (RaceOrganization anOrganizer : RaceOrganization.ussaDivisions) {
            aList.add(anOrganizer);
        }
        aList.add(RaceOrganization.USSA);
        for (RaceOrganization anOrganizer : RaceOrganization.foreignOrganizations) {
            aList.add(anOrganizer);
        }
        aList.add(RaceOrganization.UNKNOWN);
        return aList;
    }

    public List<CourseArrangement> getCourseArrangementsList() {
        if (this.courseArrangementsList == null) {
            this.courseArrangementsList = this.constructCourseArrangementsList();
        }
        return this.courseArrangementsList;
    }

    public List<Object> getOpenTools(Class<?> appType) {
        ArrayList<Object> appModels = new ArrayList<Object>();
        for (Window aWindow : UISessionManager.current.getOpenWindows()) {
            ApplicationModel anApp;
            if (!(aWindow instanceof ApplicationView) || !appType.isAssignableFrom((anApp = ((ApplicationView)((Object)aWindow)).getAppModel()).getClass())) continue;
            appModels.add(anApp);
        }
        return appModels;
    }

    public List<RaceClassType> getRaceClassTypesList() {
        return new ArrayList<RaceClassType>(RaceClassType.STANDARD_RACE_CLASS_TYPES);
    }

    public boolean isStandardRaceClassType(RaceClassType raceClassType) {
        return RaceClassType.STANDARD_RACE_CLASS_TYPES.contains(raceClassType);
    }

    public List<RaceOrganization> getRaceOrganizersList() {
        if (this.raceOrganizersList == null) {
            this.raceOrganizersList = this.constructRaceOrganizersList();
        }
        return this.raceOrganizersList;
    }

    public List<WorldCupPointsType> getWorldCupPointsTypesList() {
        return WorldCupPointsType.SUPPORTED_TYPES;
    }
}

