/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.util.EventListenerList;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.foundation.models.WorkingSetChangeEvent;
import org.ussamasters.aces.tools.foundation.models.WorkingSetChangeListener;
import org.ussamasters.aces.tools.foundation.models.WorkingSetModelEvent;
import org.ussamasters.aces.tools.foundation.models.WorkingSetModelListener;
import org.ussamasters.aces.tools.foundation.settings.SessionRootSettings;
import org.ussamasters.aces.tools.foundation.settings.ToolConfigurationSettings;
import org.ussamasters.aces.tools.foundation.settings.ToolSessionSettings;

public class ToolSessionManager {
    public static ToolSessionManager current;
    public static final String SESSION_STARTUP_OPTION_ROOT_SETTINGS = "-rootSettings";
    public static final String SESSION_STARTUP_OPTION_SESSION_SETTINGS = "-sessionSettings";
    public static final String SESSION_STARTUP_OPTION_CONFIG_SETTINGS = "-configSettings";
    public static final String SESSION_STARTUP_OPTION_SPLASH_SCREEN = "-splashScreen";
    public static final String RESOURCE_SPLASH_SCREEN = "SplashScreen";
    public static final String RESOURCE_SPLASH_SCREEN_FILE = "SplashScreenFile";
    public static final String RESOURCE_DEFAULT_TOOL_ICON = "DefaultToolIcon";
    protected static File toolInstallationDirectory;
    protected static Map<String, String> sessionStartupOptions;
    protected Map<Object, Object> sessionResourceRegistry;
    protected Map<Object, Object> workingSetResourceRegistry;
    protected Map<ToolID, ToolInfo> toolRegistry;
    protected EventListenerList workingSetListeners;
    protected EventListenerList modelListeners;

    protected static Map<String, String> getSessionStartupOptions() {
        return sessionStartupOptions;
    }

    protected static String getSessionConfigSettingsFileName() {
        return ToolSessionManager.getSessionStartupOptions().get(SESSION_STARTUP_OPTION_SESSION_SETTINGS);
    }

    protected static String getSessionInstallationSettingsFileName() {
        return ToolSessionManager.getSessionStartupOptions().get(SESSION_STARTUP_OPTION_CONFIG_SETTINGS);
    }

    protected static String getSessionRootSettingsFileName() {
        return ToolSessionManager.getSessionStartupOptions().get(SESSION_STARTUP_OPTION_ROOT_SETTINGS);
    }

    protected static String getSessionSplashScreenPathName() {
        return ToolSessionManager.getSessionStartupOptions().get(SESSION_STARTUP_OPTION_SPLASH_SCREEN);
    }

    public static List<String> processCommandLineArgs(String[] args) {
        int nArgs = args == null ? 0 : args.length;
        ArrayList<String> unusedArgs = new ArrayList<String>();
        for (int i = 0; i < nArgs; ++i) {
            String anArg = args[i];
            boolean isSessionOption = false;
            if (SESSION_STARTUP_OPTION_ROOT_SETTINGS.equalsIgnoreCase(anArg)) {
                isSessionOption = true;
                if (++i < nArgs) {
                    ToolSessionManager.setSessionRootSettingsFileName(args[i]);
                } else {
                    DebugSupport.current().dump("Session startup arg has no value: " + anArg);
                }
            }
            if (SESSION_STARTUP_OPTION_SESSION_SETTINGS.equalsIgnoreCase(anArg)) {
                isSessionOption = true;
                if (++i < nArgs) {
                    ToolSessionManager.setSessionConfigSettingsFileName(args[i]);
                } else {
                    DebugSupport.current().dump("Session startup arg has no value: " + anArg);
                }
            }
            if (SESSION_STARTUP_OPTION_CONFIG_SETTINGS.equalsIgnoreCase(anArg)) {
                isSessionOption = true;
                if (++i < nArgs) {
                    ToolSessionManager.setSessionInstallationSettingsFileName(args[i]);
                } else {
                    DebugSupport.current().dump("Session startup arg has no value: " + anArg);
                }
            }
            if (SESSION_STARTUP_OPTION_SPLASH_SCREEN.equalsIgnoreCase(anArg)) {
                isSessionOption = true;
                if (++i < nArgs) {
                    ToolSessionManager.setSessionSplashScreenPathName(args[i]);
                } else {
                    DebugSupport.current().dump("Session startup arg has no value: " + anArg);
                }
            }
            if (isSessionOption) continue;
            unusedArgs.add(anArg);
        }
        return unusedArgs;
    }

    public static void setSessionConfigSettingsFileName(String settingsFileName) {
        ToolSessionManager.getSessionStartupOptions().put(SESSION_STARTUP_OPTION_SESSION_SETTINGS, settingsFileName);
    }

    public static void setSessionInstallationSettingsFileName(String settingsFileName) {
        ToolSessionManager.getSessionStartupOptions().put(SESSION_STARTUP_OPTION_CONFIG_SETTINGS, settingsFileName);
    }

    public static void setSessionRootSettingsFileName(String settingsFileName) {
        ToolSessionManager.getSessionStartupOptions().put(SESSION_STARTUP_OPTION_ROOT_SETTINGS, settingsFileName);
    }

    public static void setSessionSplashScreenPathName(String splashScreenPathName) {
        ToolSessionManager.getSessionStartupOptions().put(SESSION_STARTUP_OPTION_SPLASH_SCREEN, splashScreenPathName);
    }

    protected ToolSessionManager() {
        this.initialize();
    }

    public void addModelListener(WorkingSetModelListener aListener) {
        this.modelListeners.add(aListener);
    }

    public void addWorkingSetListener(WorkingSetChangeListener aListener) {
        this.workingSetListeners.add(aListener);
    }

    public void closeSplashScreen() {
        Window splashScreenWindow = (Window)this.getSessionResource(RESOURCE_SPLASH_SCREEN);
        if (splashScreenWindow == null) {
            return;
        }
        splashScreenWindow.dispose();
        this.removeSessionResource(RESOURCE_SPLASH_SCREEN);
    }

    protected void fireLoadingWorkingSet(File previousDirectory, File newDirectory) {
        WorkingSetChangeEvent theEvent = new WorkingSetChangeEvent(this, 10, previousDirectory, newDirectory);
        EventListener[] myListeners = this.getWorkingSetListeners();
        for (int i = 0; i < myListeners.length; ++i) {
            ((WorkingSetChangeListener)myListeners[i]).loadingWorkingSet(theEvent);
        }
    }

    protected void fireModelAdded(File backingFile, Object aModel) {
        WorkingSetModelEvent theEvent = new WorkingSetModelEvent(this, 20, backingFile, aModel);
        EventListener[] myListeners = this.getModelListeners();
        for (int i = 0; i < myListeners.length; ++i) {
            ((WorkingSetModelListener)myListeners[i]).modelAdded(theEvent);
        }
    }

    protected void fireModelChanged(File backingFile, Object aModel) {
        WorkingSetModelEvent theEvent = new WorkingSetModelEvent(this, 21, backingFile, aModel);
        EventListener[] myListeners = this.getModelListeners();
        for (int i = 0; i < myListeners.length; ++i) {
            ((WorkingSetModelListener)myListeners[i]).modelChanged(theEvent);
        }
    }

    protected void fireModelRemoved(File backingFile, Object aModel) {
        WorkingSetModelEvent theEvent = new WorkingSetModelEvent(this, 22, backingFile, aModel);
        EventListener[] myListeners = this.getModelListeners();
        for (int i = 0; i < myListeners.length; ++i) {
            ((WorkingSetModelListener)myListeners[i]).modelRemoved(theEvent);
        }
    }

    protected void fireWorkingSetLoaded(File previousDirectory, File newDirectory) {
        WorkingSetChangeEvent theEvent = new WorkingSetChangeEvent(this, 11, previousDirectory, newDirectory);
        EventListener[] myListeners = this.getWorkingSetListeners();
        for (int i = 0; i < myListeners.length; ++i) {
            ((WorkingSetChangeListener)myListeners[i]).workingSetLoaded(theEvent);
        }
    }

    protected EventListener[] getModelListeners() {
        return this.modelListeners.getListeners();
    }

    protected EventListener[] getWorkingSetListeners() {
        return this.workingSetListeners.getListeners();
    }

    public Object getSessionResource(Object key) {
        return this.sessionResourceRegistry.get(key);
    }

    public File getSystemDirectory() {
        return SessionRootSettings.current.getSystemDirectory();
    }

    public ToolInfo getToolInfo(ToolID toolID) {
        return this.toolRegistry.get(toolID);
    }

    public ToolInfo getToolInfo(String toolName) {
        ToolID toolID = ToolID.getConstant(toolName);
        return toolID == null ? null : this.getToolInfo(toolID);
    }

    public File getToolInstallationDirectory() {
        return toolInstallationDirectory;
    }

    public File getUserConfigurationDirectory() {
        return SessionRootSettings.current.getUserConfigurationDirectory();
    }

    public File getUserDataDirectory() {
        return SessionRootSettings.current.getUserDataDirectory();
    }

    public Object getWorkingSetResource(Object key) {
        return this.workingSetResourceRegistry.get(key);
    }

    protected void initialize() {
        this.sessionResourceRegistry = new HashMap<Object, Object>();
        this.workingSetResourceRegistry = new HashMap<Object, Object>();
        this.toolRegistry = new HashMap<ToolID, ToolInfo>();
        this.workingSetListeners = new EventListenerList(WorkingSetChangeListener.class);
        this.modelListeners = new EventListenerList(WorkingSetModelListener.class);
    }

    public void notifyModelAdded(File backingFile, Object aModel) {
        this.fireModelAdded(backingFile, aModel);
    }

    public void notifyModelChanged(File backingFile, Object aModel) {
        this.fireModelChanged(backingFile, aModel);
    }

    public void notifyModelRemoved(File backingFile, Object aModel) {
        this.fireModelRemoved(backingFile, aModel);
    }

    public Collection<ToolInfo> registeredTools() {
        return this.toolRegistry.values();
    }

    public void registerSessionResource(Object key, Object resource) {
        this.sessionResourceRegistry.put(key, resource);
    }

    public void registerTool(ToolInfo toolInfo) {
        this.toolRegistry.put(toolInfo.toolID, toolInfo);
    }

    public void registerWorkingSetResource(Object key, Object resource) {
        this.workingSetResourceRegistry.put(key, resource);
    }

    protected void removeAllWorkingSetResources() {
        this.workingSetResourceRegistry.clear();
    }

    public void removeModelListener(WorkingSetModelListener aListener) {
        this.modelListeners.remove(aListener);
    }

    public void removeWorkingSetListener(WorkingSetChangeListener aListener) {
        this.workingSetListeners.remove(aListener);
    }

    public void removeSessionResource(Object key) {
        this.sessionResourceRegistry.remove(key);
    }

    public void removeWorkingSetResource(Object key) {
        this.workingSetResourceRegistry.remove(key);
    }

    static {
        toolInstallationDirectory = null;
        sessionStartupOptions = new HashMap<String, String>();
        ToolSessionManager.setSessionConfigSettingsFileName(ToolSessionSettings.FILE_NAME);
        ToolSessionManager.setSessionInstallationSettingsFileName(ToolConfigurationSettings.FILE_NAME);
    }
}

