/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import java.io.File;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerList;

public class WorkingSetScoringData {
    public static final String RACER_INFO_FILENAME_SUFFIX = "-Racers";
    protected RaceIdentifier raceID;
    protected String raceFileRootName;
    protected File raceResultFile;
    protected RaceResult raceResult;
    protected File racerInfoFile;
    protected RacerList racerInfo;

    public WorkingSetScoringData(RaceIdentifier raceID) {
        this.raceID = raceID;
        this.raceFileRootName = RaceDataIOServices.raceResultsBaseFileName(this.raceID);
    }

    public void deleteRaceData() {
        this.deleteRacerInfo();
        this.deleteRaceResult();
    }

    protected void deleteRacerInfo() {
        if (this.racerInfoFile != null) {
            this.racerInfoFile.delete();
            this.racerInfoFile = null;
            this.racerInfo = null;
        }
        if (this.racerInfo != null) {
            throw new IllegalStateException("Invalid WorkingSetScoringData for " + this.raceID + ": racer info data loaded but file reference was null");
        }
    }

    protected void deleteRaceResult() {
        if (this.raceResultFile != null) {
            this.raceResultFile.delete();
            this.raceResultFile = null;
            this.raceResult = null;
        }
        if (this.raceResult != null) {
            throw new IllegalStateException("Invalid WorkingSetScoringData for " + this.raceID + ": result data loaded but file reference was null");
        }
    }

    public RaceIdentifier getRaceID() {
        return this.raceID;
    }

    public String getRaceFileRootName() {
        return this.raceFileRootName;
    }

    public boolean isReconciled() {
        return this.racerInfoFile == null;
    }

    public String raceResultsFileName() {
        return RaceDataIOConstants.FILE_TYPE_RACE_RESULTS_DATA.composeFileName(this.raceFileRootName);
    }

    public String racerInfoFileName() {
        return RaceDataIOConstants.FILE_TYPE_RACER_INFO_DATA.composeFileName(this.raceFileRootName + RACER_INFO_FILENAME_SUFFIX);
    }

    public void setReconciled(boolean isReconciled) {
        this.deleteRacerInfo();
    }
}

