/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.processors;

import com.glaivestone.javax.devx.Assert;
import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.SplashScreenWindow;
import com.glaivestone.mv.swing.SwingUISessionManager;
import com.glaivestone.toolbox.settings.SettingsFileHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.ussamasters.aces.tools.foundation.processors.SystemConfigurationSettingsProcessor;
import org.ussamasters.aces.tools.foundation.settings.SessionRootSettings;

public abstract class InstallationConfigurationSettingsProcessor {
    protected SettingsFileHolder rootSettings;
    protected Window splashScreenWindow;

    public InstallationConfigurationSettingsProcessor(SettingsFileHolder rootSettings) {
        this.setRootSettings(rootSettings);
    }

    public void closeSplashScreen() {
        if (this.splashScreenWindow == null) {
            return;
        }
        this.splashScreenWindow.dispose();
        this.setSplashScreenWindow(null);
    }

    protected void displaySplashScreen(ImageIcon splashScreen) {
        this.setSplashScreenWindow(SplashScreenWindow.openOn(splashScreen));
    }

    protected void displaySplashScreen(File imageFile) {
        this.setSplashScreenWindow(SplashScreenWindow.openOn(imageFile));
    }

    public void displaySplashScreen(String splashScreenFileRef) {
        if (splashScreenFileRef == null) {
            return;
        }
        Assert.isTrue(this.splashScreenWindow == null, "Attempting to display splash screen from " + splashScreenFileRef + " when already displayed");
        ImageIcon splashScreen = this.resolveSplashScreenReference(splashScreenFileRef);
        if (splashScreen == null) {
            DebugSupport.current().dump("Session splash screen not found: " + splashScreenFileRef);
            return;
        }
        this.displaySplashScreen(splashScreen);
    }

    protected abstract File getBaseDirectory();

    protected abstract SettingsSection getConfigSettings();

    protected File getLogFileDirectory() {
        return SessionRootSettings.getCurrent().getLogDirectory();
    }

    protected SettingsFileHolder getRootSettings() {
        return this.rootSettings;
    }

    protected void installLookAndFeel(String lookAndFeelName) {
        if ("hostSystem".equals(lookAndFeelName)) {
            SwingUISessionManager.current.installHostSystemLookAndFeel();
            return;
        }
        if ("crossPlatform".equals(lookAndFeelName)) {
            SwingUISessionManager.current.installCrossPlatformLookAndFeel();
            return;
        }
        SwingUISessionManager.current.installHostSystemLookAndFeel();
    }

    protected void processEarlyStartupSpecifications() {
        this.processLookAndFeelSetting();
        this.processSplashScreenSetting();
    }

    public void processLookAndFeelSetting() {
        String lookAndFeel = this.getConfigSettings().getStringValue("lookAndFeel");
        this.installLookAndFeel(lookAndFeel);
    }

    public void processSplashScreenSetting() {
        if (this.splashScreenWindow != null) {
            return;
        }
        String splashScreenFileRef = this.getConfigSettings().getStringValue("splashScreen");
        this.displaySplashScreen(splashScreenFileRef);
    }

    protected void processSystemSpecifications() {
        SystemConfigurationSettingsProcessor.processConfigurationSettings(this.getRootSettings(), this.getLogFileDirectory());
    }

    protected ImageIcon resolveSplashScreenReference(String splashScreenFileRef) {
        File imageFile = new File(splashScreenFileRef);
        if (imageFile.isFile()) {
            try {
                return new ImageIcon(IOUtils.toByteArray(imageFile.toURI()));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    protected ImageIcon loadImageFile(String imageFileRef, File fileSystemDirectory) {
        byte[] image = null;
        try {
            File imageFile;
            try (InputStream fs = this.getClass().getResourceAsStream(imageFileRef);){
                if (fs != null) {
                    image = IOUtils.toByteArray(fs);
                }
            }
            if (image == null && (imageFile = new File(fileSystemDirectory, imageFileRef)).isFile()) {
                image = IOUtils.toByteArray(imageFile.toURI());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ImageIcon splashScreen = null;
        if (image != null) {
            splashScreen = new ImageIcon(image);
        }
        return splashScreen;
    }

    protected void setRootSettings(SettingsFileHolder rootSettings) {
        this.rootSettings = rootSettings;
    }

    protected void setSplashScreenWindow(Window aSplashScreenWindow) {
        this.splashScreenWindow = aSplashScreenWindow;
    }
}

