/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.settings;

import com.glaivestone.javax.execution.SessionManager;
import java.io.File;
import java.io.IOException;
import org.ussamasters.aces.tools.foundation.settings.SessionRootSettings;

public class ACESRootSettings
extends SessionRootSettings {
    public static final String NAME = "ACEScoring";
    public static final String FILE_NAME = FILE_TYPE.composeFileName("ACEScoring");
    public static final String DEFAULT_DATASETS_DIRECTORY = "-r-..\\ACESData";

    public static synchronized void loadCurrent(File aDirectory, String configSettingsFileName) {
        try {
            SessionRootSettings.current = ACESRootSettings.loadFromDirectory(aDirectory, configSettingsFileName);
        }
        catch (Exception ex) {
            System.err.println("***FATAL INSTALLATION ERROR: unable to load session root settings file " + configSettingsFileName + " in " + aDirectory.getAbsolutePath() + ".");
            System.err.println(ex);
            SessionManager.current.shutdown();
        }
    }

    public static synchronized SessionRootSettings loadFromDirectory(File aDirectory, String configSettingsFileName) throws IOException {
        if (aDirectory == null || !aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Bad client: not a session root directory - " + aDirectory);
        }
        File configSettingsFile = new File(aDirectory, configSettingsFileName);
        if (!configSettingsFile.exists()) {
            throw new IllegalArgumentException("Bad client: no session root settings - " + configSettingsFileName);
        }
        return new ACESRootSettings(configSettingsFile);
    }

    public ACESRootSettings(File backingFile) throws IOException {
        super(backingFile);
    }

    @Override
    protected String defaultUserDataDirectoryName() {
        return DEFAULT_DATASETS_DIRECTORY;
    }
}

