/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import java.awt.Window;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.USSALicense;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.EditRacerDataDialog;

public class NewRacerDialog
extends EditRacerDataDialog {
    private static final String DIALOG_TITLE = "New Racer";
    protected static final String UNKNOWN_BIRTH_YEAR = "yyyy";
    protected static final String UNKNOWN_USSA_NUMBER = "";

    public static Racer openFor(Window aWindow, ToolSessionRacerList racerList) {
        NewRacerDialog aDialog = new NewRacerDialog(aWindow, racerList);
        aDialog.openWindow();
        return aDialog.getNewRacerData();
    }

    public static Racer openOn(Racer proposedNewRacer, ToolSessionRacerList racerList, Window aWindow) {
        NewRacerDialog aDialog = new NewRacerDialog(aWindow, racerList);
        aDialog.initRacerDataValues(proposedNewRacer);
        aDialog.openWindow();
        return aDialog.getNewRacerData();
    }

    public static ValidationResult validateNewRacer(Racer proposedNewRacer, ToolSessionRacerList racerList) {
        NewRacerDialog aDialog = new NewRacerDialog(null, racerList);
        aDialog.initRacerDataValues(proposedNewRacer);
        return aDialog.validateChanges(NO_USER_INTERACTION_RESOLVER);
    }

    protected NewRacerDialog(Window aWindow, ToolSessionRacerList racerList) {
        super(aWindow, racerList);
        this.initRacerDataValues();
    }

    @Override
    public void acceptChanges() {
        Integer bibNumberValue = (Integer)this.getChangedValues().get("bibNumber");
        RaceClass ageClass = (RaceClass)this.getChangedValues().get("ageClass");
        RaceClass nationalClass = (RaceClass)this.getChangedValues().get("nationalClass");
        Integer birthYear = (Integer)this.getChangedValues().get("birthYear");
        String ussaNumber = (String)this.getChangedValues().get("ussaNumber");
        Racer aRacer = new Racer(bibNumberValue, (String)this.getChangedValues().get("lastName"), (String)this.getChangedValues().get("firstName"));
        aRacer.initCompetitionClassValues(null, ageClass, nationalClass, birthYear != null ? birthYear : -1);
        if (nationalClass.isUnknown()) {
            aRacer.initNationalClass(this.getSeason());
        }
        aRacer.initLicenseValues((RaceOrganization)this.getChangedValues().get("affiliation"), ussaNumber);
        this.clearChanges();
        this.newRacerData = aRacer;
    }

    @Override
    protected void computeChanges() {
        super.computeChanges();
        this.getChangedValues().recordValue("lastName", this.getLastNameHolder().getText().trim());
        this.getChangedValues().recordValue("firstName", this.getFirstNameHolder().getText().trim());
        this.getChangedValues().recordValue("bibNumber", this.getBibNumberHolder().getText().trim());
        RaceClass<?> ageClass = this.getSelectedAgeClass();
        this.getChangedValues().recordValue("ageClass", ageClass);
        if (this.mapsAgeClassToNationalClass()) {
            this.mapAgeClassToNationalClass(ageClass);
        }
        this.getChangedValues().recordValue("nationalClass", this.getSelectedNationalClass());
        String aValue = this.getBirthYearHolder().getText().trim();
        if (aValue.length() != 0) {
            this.getChangedValues().recordValueIfChanged("birthYear", this.unknownBirthYearString(), aValue);
        }
        this.getChangedValues().recordValue("affiliation", this.getSelectedAffiliation());
        this.getChangedValues().recordValueIfChanged("ussaNumber", UNKNOWN_USSA_NUMBER, this.getUSSANumberHolder().getText().trim());
        if (this.getChangedValues().get("ussaNumber") == null) {
            this.getChangedValues().recordValue("ussaNumber", "9999999");
        }
    }

    @Override
    public String getTitle() {
        return DIALOG_TITLE;
    }

    protected void initRacerDataValues() {
        this.setNextAvailableBibNumber();
        this.getBirthYearHolder().setText(this.unknownBirthYearString());
        this.getAffiliationListHolder().setSelectedItem(RaceOrganization.UNKNOWN);
        this.getUSSANumberHolder().setText(UNKNOWN_USSA_NUMBER);
    }

    @Override
    protected void initRacerDataValues(Racer aRacer) {
        super.initRacerDataValues(aRacer);
        if (aRacer.getUSSALicense() == null || !USSALicense.isValid(aRacer.getUSSALicense().toString())) {
            this.getUSSANumberHolder().setText(UNKNOWN_USSA_NUMBER);
        }
    }

    @Override
    protected String unknownBirthYearString() {
        return UNKNOWN_BIRTH_YEAR;
    }

    @Override
    public ValidationResult validateChanges(ValidationResolver validationResolver) {
        ValidationResult validationResult = new ValidationResult();
        String lastName = (String)this.getChangedValues().get("lastName");
        String firstName = (String)this.getChangedValues().get("firstName");
        RaceClass ageClass = (RaceClass)this.getChangedValues().get("ageClass");
        RaceClass nationalClass = (RaceClass)this.getChangedValues().get("nationalClass");
        RaceOrganization affiliation = this.getSelectedAffiliation();
        String ussaNumber = (String)this.getChangedValues().get("ussaNumber");
        this.validateName(lastName, firstName, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        this.validateBibNumber(lastName, firstName, validationResolver, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        this.validateBirthYear(validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        Integer bibNumber = (Integer)this.getChangedValues().get("bibNumber");
        Integer yearBorn = (Integer)this.getChangedValues().get("birthYear");
        this.verifyNameIsNotAlreadyRegistered(lastName, firstName, ageClass, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        this.verifySimilarNameRegistrationIsAcceptable(lastName, firstName, validationResolver, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        this.validateBibNumber(bibNumber, affiliation, lastName, firstName, "affiliation", validationResolver, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        this.validateAgeClass(ageClass, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        this.validateAgeClassConsistency(ageClass, nationalClass, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        if (yearBorn != null) {
            this.validateAgeClassConsistency(ageClass, nationalClass, yearBorn, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
            this.verifyNationalClassIsAcceptable(nationalClass, yearBorn, validationResolver, validationResult);
            if (validationResult.failed()) {
                return validationResult;
            }
        }
        this.validateUSSANumber(lastName, firstName, validationResolver, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        this.validateLicenseAndAffiliationConsistency(affiliation, ussaNumber, validationResolver, validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        return ValidationResult.SUCCESS_RESULT;
    }
}

