/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.io.FileSystemReference;
import com.glaivestone.javax.io.FileSystemServices;
import com.glaivestone.javax.swing.PlainTextDocument;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.tools.foundation.models.EventScoringRaceSeries;
import org.ussamasters.aces.tools.foundation.models.EventScoringSpecification;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.RaceDataDialog;

public class NewScoringEventDialog
extends RaceDataDialog {
    public static final String PROPERTY_EVENT_NAME = "eventName";
    public static final String PROPERTY_EVENT_SHORT_NAME = "eventShortName";
    public static final String PROPERTY_EVENT_FILE_NAME = "eventFileName";
    private static final String DIALOG_TITLE = "New Scoring Event";
    protected EventScoringRaceSeries newEvent;
    protected EventScoringSpecification eventSpecification;
    protected PlainTextDocument eventFileNameHolder;
    protected PlainTextDocument eventNameHolder;
    protected PlainTextDocument eventDescriptionHolder;
    protected DefaultComboBoxModel<RaceClassType> eventRaceClassHolder;
    protected DefaultComboBoxModel<WorldCupPointsType> worldCupPointsTypeHolder;

    public static EventScoringRaceSeries openFor(Window aWindow) {
        NewScoringEventDialog aDialog = new NewScoringEventDialog(aWindow);
        aDialog.openWindow();
        return aDialog.getNewEvent();
    }

    public NewScoringEventDialog(Window aWindow) {
        super(aWindow);
        this.initializeModels();
    }

    public void acceptChanges() throws IOException, RaceDataIOException {
        File eventSpecFile = this.getProposedEventSpecFile();
        FileSystemServices.getCurrent().realizeDirectory(eventSpecFile.getParentFile());
        this.eventSpecification.saveSettings(eventSpecFile);
        this.newEvent = this.getSessionManager().loadEventScoringSpecification(eventSpecFile);
    }

    @Override
    public void clearResult() {
        this.newEvent = null;
    }

    protected DefaultComboBoxModel<RaceClassType> constructRaceClassClassesHolder(RaceClassType selectedRaceClass) {
        List<RaceClassType> raceClassTypesList = this.getToolServices().getRaceClassTypesList();
        if (selectedRaceClass != null && !raceClassTypesList.contains(selectedRaceClass)) {
            raceClassTypesList.add(selectedRaceClass);
        }
        return this.getToolUIModelServices().constructComboBoxListHolder(raceClassTypesList);
    }

    protected DefaultComboBoxModel<WorldCupPointsType> constructWorldCupPointsTypeHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(WorldCupPointsType.SUPPORTED_TYPES);
    }

    public PlainTextDocument getEventDescriptionHolder() {
        return this.eventDescriptionHolder;
    }

    public PlainTextDocument getEventFileNameHolder() {
        return this.eventFileNameHolder;
    }

    protected String getEventName() {
        return this.getEventNameHolder().getText().trim();
    }

    public PlainTextDocument getEventNameHolder() {
        return this.eventNameHolder;
    }

    public DefaultComboBoxModel<RaceClassType> getEventRaceClassHolder() {
        return this.eventRaceClassHolder;
    }

    public DefaultComboBoxModel<WorldCupPointsType> getWorldCupPointsTypeHolder() {
        return this.worldCupPointsTypeHolder;
    }

    public EventScoringRaceSeries getNewEvent() {
        return this.newEvent;
    }

    protected File getProposedEventSpecFile() {
        String eventShortName = this.getEventFileNameHolder().getText().trim();
        return new File(this.getSessionManager().getEventScoringDataDirectory(), EventScoringSpecification.composeFileName(eventShortName));
    }

    protected Class<? extends RaceClass<?>> getSelectedEventRaceClass(SeasonIdentifier season) {
        RaceClassType raceClassType = (RaceClassType)this.eventRaceClassHolder.getSelectedItem();
        return SeasonConfiguration.getSeasonConfig(season).getRaceClassClass(raceClassType);
    }

    protected WorldCupPointsType getSelectedWorldCupPointsType() {
        return (WorldCupPointsType)((Object)this.worldCupPointsTypeHolder.getSelectedItem());
    }

    public String getTitle() {
        return DIALOG_TITLE;
    }

    protected void initializeModels() {
        this.eventFileNameHolder = new PlainTextDocument("CombinedEvent");
        this.eventNameHolder = new PlainTextDocument("Combined Event");
        this.eventDescriptionHolder = new PlainTextDocument("A combined event");
        RaceClassType raceClassType = RaceClassRegistry.current().getRaceClassType(WorkingSetSettings.getCurrent().getRaceClassClass());
        this.eventRaceClassHolder = this.constructRaceClassClassesHolder(raceClassType);
        this.eventRaceClassHolder.setSelectedItem(raceClassType);
        this.worldCupPointsTypeHolder = this.constructWorldCupPointsTypeHolder();
        this.worldCupPointsTypeHolder.setSelectedItem((Object)WorkingSetSettings.getCurrent().getWorldCupPointsType());
    }

    public ValidationResult validateChanges(ValidationResolver validationResolver) {
        ValidationResult validationResult = new ValidationResult();
        String eventName = this.getEventName();
        String eventDescription = this.getEventDescriptionHolder().getText().trim();
        List<String> combinedEventsList = this.getSessionManager().getScoringEventNames();
        for (String anEventName : combinedEventsList) {
            if (!eventName.equalsIgnoreCase(anEventName)) continue;
            validationResult.reportProblem(PROPERTY_EVENT_NAME, "The scoring event name you have requested is already in use");
            return validationResult;
        }
        File eventSpecFile = this.getProposedEventSpecFile();
        if (eventSpecFile.exists()) {
            validationResult.reportProblem(PROPERTY_EVENT_FILE_NAME, "The scoring event file name you have requested already exists");
            return validationResult;
        }
        String fileName = FileSystemReference.getFileBaseName(eventSpecFile.getName());
        String invalidChar = this.validateFileNameComponent(fileName);
        if (invalidChar != null) {
            validationResult.reportProblem(PROPERTY_EVENT_SHORT_NAME, "The short name you have specified for storing the event data is not valid - please remove the special character '" + invalidChar + "' (may cause problems when used in report file names).");
            return validationResult;
        }
        SeasonIdentifier season = WorkingSetSettings.getCurrent().getSeason();
        EventScoringSpecification proposedEventSpecification = EventScoringSpecification.createSpecification(eventName, null, season, this.getSelectedEventRaceClass(season), this.getSelectedWorldCupPointsType());
        proposedEventSpecification.setDescription(eventDescription);
        this.eventSpecification = proposedEventSpecification;
        return ValidationResult.SUCCESS_RESULT;
    }
}

