/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.execution.ConstructorAction;
import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.OperatingSystemHelper;
import com.glaivestone.javax.execution.SessionManager;
import com.glaivestone.javax.io.FileSystemServices;
import com.glaivestone.javax.io.FileType;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.util.PropagatedException;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.BooleanHolder;
import com.glaivestone.mv.FrameWindowApplicationModel;
import com.glaivestone.mv.UISessionManager;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.tools.foundation.models.RaceScoringSessionManager;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.foundation.models.ToolServices;
import org.ussamasters.aces.tools.foundation.models.WorkingSetChangeEvent;
import org.ussamasters.aces.tools.foundation.models.WorkingSetChangeListener;
import org.ussamasters.aces.tools.foundation.models.WorkingSetTool;
import org.ussamasters.aces.tools.ui.ToolUIModelServices;

public class RaceDataTool
extends FrameWindowApplicationModel
implements WorkingSetTool,
WorkingSetChangeListener {
    protected static String DEFAULT_APPLICATION_TITLE = "Race Data Tool";
    private static final Class<RaceDataTool> THIS_CLASS = RaceDataTool.class;
    protected ToolID toolID;
    protected RaceScoringSessionManager sessionManager;
    protected ToolServices toolServices;
    protected BooleanHolder workingSetChangedHolder;

    public static boolean closeAllViews(ToolID toolID) {
        for (ApplicationView aView : RaceDataTool.getAllViews(toolID)) {
            if (aView.requestCloseWindow()) continue;
            return false;
        }
        return RaceDataTool.getAllViews(toolID).size() == 0;
    }

    protected static EvaluableAction constructToolConstructionAction(Class<?> toolClass) {
        return ConstructorAction.create(toolClass);
    }

    protected static RaceDataTool createTool(ToolID toolID, EvaluableAction constructorAction) {
        try {
            return (RaceDataTool)constructorAction.evaluate();
        }
        catch (PropagatedException ex) {
            RaceDataTool.reportFatalStartupError(toolID, ex.getCause());
            return null;
        }
    }

    public static ApplicationView findWindow(ToolID toolID) {
        List<ApplicationView> views = RaceDataTool.getAllViews(toolID);
        if (views.size() == 0) {
            return null;
        }
        if (views.size() > 1) {
            throw new IllegalArgumentException("Not a single-instance tool: " + toolID.name);
        }
        return views.get(0);
    }

    public static List<ApplicationView> getAllViews(ToolID toolID) {
        ArrayList<ApplicationView> views = new ArrayList<ApplicationView>();
        for (Window aWindow : UISessionManager.current.getOpenWindows()) {
            ApplicationView appView;
            if (!(aWindow instanceof ApplicationView) || !((appView = (ApplicationView)((Object)aWindow)).getAppModel() instanceof WorkingSetTool) || ((WorkingSetTool)((Object)appView.getAppModel())).getToolID() != toolID) continue;
            views.add(appView);
        }
        return views;
    }

    public static void initiateSession() {
        String failureMessage = "Race data tool session initiation processing failed.";
        try {
            RaceScoringSessionManager.initiateSession();
        }
        catch (IOException ex) {
            RaceDataTool.reportFatalStartupError(failureMessage, (Throwable)ex);
        }
        catch (RaceDataIOException ex) {
            RaceDataTool.reportFatalStartupError(failureMessage, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            RaceDataTool.reportFatalStartupError(failureMessage, (Throwable)ex);
        }
    }

    public static void processCommandLineArgs(String[] args) {
        List<String> unusedArgs = RaceScoringSessionManager.processCommandLineArgs(args);
        if (unusedArgs.size() > 0) {
            DebugSupport.current().dump("WARNING: Unrecognized session command line arguments specified:");
            for (String arg : unusedArgs) {
                DebugSupport.current().dump("..." + arg);
            }
        }
    }

    public static ApplicationView openToolWindow(ToolID toolID, EvaluableAction constructorAction) {
        RaceDataTool appModel = RaceDataTool.createTool(toolID, constructorAction);
        return appModel != null ? RaceDataTool.openToolWindow(toolID, appModel) : null;
    }

    protected static ApplicationView openToolWindow(ToolID toolID, RaceDataTool appModel) {
        try {
            return (ApplicationView)((Object)appModel.openWindow());
        }
        catch (PropagatedException ex) {
            RaceDataTool.reportFatalStartupError(toolID, ex.getCause());
            return null;
        }
    }

    protected static void registerSessionResource(String name, Object value) {
        RaceScoringSessionManager.getCurrent().registerSessionResource(name, value);
    }

    public static void reportFatalStartupError(String message, Throwable anException) {
        if (anException != null) {
            DebugSupport.current().dumpStack(anException);
        }
        MessageDialog.displayError("Race Data Tool Session Startup Failed", message, null);
        if (!DebugSupport.debugEnabled) {
            SessionManager.current.shutdown();
        }
    }

    protected static void reportFatalStartupError(ToolID clientToolID, Throwable anException) {
        RaceDataTool.reportFatalStartupError("Unable to start " + clientToolID.name + ": " + anException.getMessage(), anException);
    }

    public RaceDataTool() {
        this((ToolID)null, DEFAULT_APPLICATION_TITLE);
    }

    protected RaceDataTool(ToolID toolID, String title) {
        this(toolID, title, "(none)");
    }

    protected RaceDataTool(ToolID toolID, String title, String subjectDescription) {
        super(title, subjectDescription);
        this.toolID = toolID;
        this.initialize();
    }

    @Override
    protected String defaultWindowClassName() {
        return this.defaultWindowClassName(this.getClass());
    }

    protected String defaultWindowClassName(Class<? extends RaceDataTool> appModelClass) {
        return String.format("%s.swing.%sWindow", appModelClass.getPackage().getName(), appModelClass.getSimpleName());
    }

    protected File findOrCreateCorrectionsLog(File aDirectory) throws IOException {
        String fileName = FileType.TEXT.composeFileName("CorrectionsLog");
        File correctionsLogFile = new File(aDirectory, fileName);
        if (!correctionsLogFile.exists()) {
            RaceDate today = new RaceDate();
            FileSystemServices.getCurrent().realizeDirectory(aDirectory);
            PrintWriter fs = new PrintWriter(new BufferedWriter(new FileWriter(correctionsLogFile)));
            fs.println("-- " + fileName);
            fs.println("-- Created: " + today);
            fs.println("-- Last Edited " + today);
            fs.println();
            fs.close();
        }
        return correctionsLogFile;
    }

    @Override
    protected String getIconResourceName() {
        ToolInfo toolInfo = this.getSessionManager().getToolInfo(this.getToolID());
        String iconResourceName = null;
        if (toolInfo != null) {
            iconResourceName = toolInfo.getIconReference();
        }
        if (iconResourceName == null) {
            iconResourceName = (String)this.getSessionManager().getSessionResource("DefaultToolIcon");
        }
        return iconResourceName != null ? iconResourceName : super.getIconResourceName();
    }

    public RaceScoringSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public ToolID getToolID() {
        return this.toolID;
    }

    public ToolServices getToolServices() {
        return this.toolServices;
    }

    public ToolUIModelServices getToolUIModelServices() {
        return ToolUIModelServices.getCurrent();
    }

    public BooleanHolder getWorkingSetChangedHolder() {
        return this.workingSetChangedHolder;
    }

    protected void initialize() {
        this.sessionManager = RaceScoringSessionManager.getCurrent();
        this.toolServices = ToolServices.getCurrent();
        this.initializeModels();
    }

    protected void initializeModels() {
        if (this.supportsWorkingSetSwitching()) {
            this.workingSetChangedHolder = new BooleanHolder();
        }
    }

    @Override
    public void loadingWorkingSet(WorkingSetChangeEvent event) {
    }

    protected void openCorrectionsLog(File aDirectory) throws IOException {
        OperatingSystemHelper.current().openFile(this.findOrCreateCorrectionsLog(aDirectory));
    }

    protected void registerWorkingSetListener() {
        this.getSessionManager().addWorkingSetListener(this);
    }

    protected void removeWorkingSetListener() {
        this.getSessionManager().removeWorkingSetListener(this);
    }

    protected void showDirectory(File aDirectory) throws IOException {
        OperatingSystemHelper.current().openDirectory(aDirectory);
    }

    public boolean supportsWorkingSetSwitching() {
        return false;
    }

    @Override
    protected void windowClosing(Window aWindow) {
        if (this.supportsWorkingSetSwitching()) {
            this.removeWorkingSetListener();
        }
        super.windowClosing(aWindow);
    }

    @Override
    protected void windowOpened(Window aWindow) {
        super.windowOpened(aWindow);
        this.getSessionManager().closeSplashScreen();
        if (this.supportsWorkingSetSwitching()) {
            this.registerWorkingSetListener();
        }
    }

    @Override
    public void workingSetLoaded(WorkingSetChangeEvent event) {
        if (this.getClass() == THIS_CLASS) {
            throw new UnsupportedOperationException("Must be implemented by tools which support working set switching");
        }
        this.getWorkingSetChangedHolder().toggleValue();
    }
}

