/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.io.FileType;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.BooleanHolder;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceEntryResult2Run;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.ui.RaceResultDataTool;
import org.ussamasters.aces.tools.ui.RaceResultTableHolder;
import org.ussamasters.aces.tools.ui.RaceSpecificationModel;

public class RaceResultEditor
extends RaceResultDataTool {
    protected static String APPLICATION_TITLE = "Race Result Editor";
    public static final ToolID TOOL_ID = new ToolID("RaceResultEditor");
    protected RaceResult raceResult;
    protected RacerList competitorInfo;
    protected BooleanHolder resultsChangedHolder;
    protected boolean mustRecomputeStandings;
    protected RaceSpecificationModel raceSpecificationModel;
    protected RaceResultTableHolder raceResultTableHolder;

    public static ApplicationView findOrOpen(RaceResult aRaceResult, RacerList competitorInfo) {
        List<ApplicationView> windows = RaceResultEditor.getAllViews(TOOL_ID);
        for (ApplicationView appView : windows) {
            if (appView == null || !((RaceResultEditor)appView.getAppModel()).raceResult.equals(aRaceResult)) continue;
            Frame frameWindow = (Frame)appView.getMainWindow();
            if (frameWindow.getState() == 1) {
                frameWindow.setState(0);
            } else {
                frameWindow.toFront();
            }
            frameWindow.requestFocus();
            return appView;
        }
        ApplicationView aWindow = RaceResultEditor.openOn(aRaceResult, competitorInfo);
        return aWindow;
    }

    public static void installTool(ToolInfo toolInfo) {
        String displayName = toolInfo.getDisplayName();
        if (displayName != null) {
            APPLICATION_TITLE = displayName;
        }
    }

    public static ApplicationView openOn(RaceResult aRaceResult, RacerList competitorInfo) {
        RaceResultEditor aViewer = new RaceResultEditor(aRaceResult, competitorInfo);
        return (ApplicationView)((Object)aViewer.openWindow());
    }

    public RaceResultEditor(RaceResult raceResult, RacerList competitorInfo) {
        super(TOOL_ID, APPLICATION_TITLE);
        this.raceResult = raceResult.copy();
        this.competitorInfo = competitorInfo;
        this.initializeWorkingSetDataModels();
    }

    public int getNumberOfRuns() {
        return this.raceResult.getNumberOfRuns();
    }

    public Class<? extends RaceClass<?>> getRaceClassClass() {
        return this.getRaceSpecificationModel().getRaceSpecification().getRaceClassClass();
    }

    public RaceSpecificationModel getRaceSpecificationModel() {
        return this.raceSpecificationModel;
    }

    @Override
    public RaceResult getRaceResult(RaceIdentifier raceID) {
        if (raceID != this.raceResult.getRaceId()) {
            throw new IllegalArgumentException("Should only request results for the edited race - invalid arg: " + raceID);
        }
        return super.getRaceResult(raceID);
    }

    @Override
    public RacerList getRaceResultCompetitorInfo(RaceIdentifier raceID) throws RaceDataIOException {
        if (raceID != this.raceResult.getRaceId()) {
            throw new IllegalArgumentException("Should only request competitor info for the edited race - invalid arg: " + raceID);
        }
        return super.getRaceResultCompetitorInfo(raceID);
    }

    @Override
    public RacerList getRaceResultCompetitors(RaceIdentifier raceID) throws RaceDataIOException {
        if (raceID != this.raceResult.getRaceId()) {
            throw new IllegalArgumentException("Should only request competitor info for the edited race - invalid arg: " + raceID);
        }
        return super.getRaceResultCompetitors(raceID);
    }

    public RaceResultTableHolder getRaceResultTableHolder() {
        return this.raceResultTableHolder;
    }

    public BooleanHolder getResultsChangedHolder() {
        return this.resultsChangedHolder;
    }

    public RaceEntryResult getSelectedResult() {
        return this.getRaceResultTableHolder().getSelectedResult();
    }

    protected RaceResult getUpdatedRaceResult() {
        RaceResult updatedResult = this.getRaceResultTableHolder().getRaceResult();
        if (this.getRaceSpecificationModel().hasChanges()) {
            RaceDescriptor updatedSpec = this.getRaceSpecificationModel().getRaceSpecification();
            if (!updatedSpec.getRaceClassClass().equals(updatedResult.getRaceClassClass())) {
                throw new UnsupportedOperationException("Change race class of result is not supported - re-Import the data for now");
            }
            updatedResult.setCourseArrangement(updatedSpec.getCourseArrangement());
        }
        if (this.mustRecomputeStandings) {
            updatedResult.recomputeRaceStatistics();
            updatedResult = this.getSessionManager().recomputeStandings(updatedResult);
        }
        return updatedResult;
    }

    public boolean hasReportsAvailable() {
        return this.hasReportsAvailable(this.raceResult.getRaceId());
    }

    public boolean hasUnsavedChanges() {
        return this.getRaceSpecificationModel().hasChanges() || this.getResultsChangedHolder().getValue();
    }

    protected void initializeWorkingSetDataModels() {
        this.resultsChangedHolder = new BooleanHolder(false);
        this.mustRecomputeStandings = false;
        this.raceSpecificationModel = new RaceSpecificationModel(RaceSpecificationModel.newRaceSpecification(this.raceResult));
        this.raceSpecificationModel.setIdentificationEditable(false);
        this.raceResultTableHolder = new RaceResultTableHolder(this.raceResult.copy());
    }

    public void regenerateRaceResultsReports() throws RaceDataIOException {
        boolean displayReports = false;
        ArrayList<FileType> reportTypes = new ArrayList<FileType>();
        for (int i = 0; i < REPORT_FORMATS.length; ++i) {
            if (this.getResultReportFiles(this.raceResult.getRaceId(), REPORT_FORMATS[i]).size() <= 0) continue;
            reportTypes.add(REPORT_FORMATS[i]);
        }
        if (reportTypes.size() == 0) {
            return;
        }
        this.generateRaceResultsReports(this.raceResult.getRaceId(), reportTypes, displayReports);
    }

    public void removeRacerResult(RaceEntryResult aRacerResult) {
        this.getRaceResultTableHolder().removeRow(aRacerResult);
        this.getResultsChangedHolder().setValue(true);
        this.mustRecomputeStandings = true;
    }

    public void saveChanges() throws RaceDataIOException {
        RaceResult updatedResults = this.getUpdatedRaceResult();
        this.getSessionManager().saveRaceResult(updatedResults);
        this.getRaceSpecificationModel().getHasChangesHolder().setValue(false);
        this.getResultsChangedHolder().setValue(false);
    }

    @Override
    protected boolean shouldAllowCloseWindow(Window aWindow) {
        if (this.hasUnsavedChanges()) {
            int answer = MessageDialog.confirmOrCancel("Unsaved Changes", "You have made changes to the race results which have not yet been saved.  Save changes?", aWindow);
            if (answer == 2) {
                return false;
            }
            if (answer == 0) {
                try {
                    this.saveChanges();
                }
                catch (RaceDataIOException ex) {
                    MessageDialog.displayError("Save Failed", "Unable to save changes to racer data: " + ex.getMessage(), aWindow);
                    return false;
                }
            }
        }
        return super.shouldAllowCloseWindow(aWindow);
    }

    public void updateRacerClass(RaceEntryResult aRacerResult, RaceClass<?> raceClass) {
        aRacerResult.setRaceClass(raceClass);
        this.getRaceResultTableHolder().refreshRow(aRacerResult);
        this.getResultsChangedHolder().setValue(true);
        this.mustRecomputeStandings = true;
    }

    public void updateRacerName(RaceEntryResult aRacerResult, String lastName, String firstName) {
        aRacerResult.setName(lastName, firstName);
        this.getRaceResultTableHolder().refreshRow(aRacerResult);
        this.getResultsChangedHolder().setValue(true);
    }

    public void updateRacerResult(RaceEntryResult aRacerResult, CompetitorResultValue<?> resultValue) {
        aRacerResult.setResultValue(resultValue);
        this.getRaceResultTableHolder().refreshRow(aRacerResult);
        this.raceResult.recomputeRaceStatistics();
        this.getResultsChangedHolder().setValue(true);
        this.mustRecomputeStandings = true;
    }

    public void updateRacerResultFirstRun(RaceEntryResult aRacerResult, CompetitorResultValue<?> runResultValue) {
        ((RaceEntryResult2Run)aRacerResult).updateFirstRun(runResultValue);
        this.getRaceResultTableHolder().refreshRow(aRacerResult);
        this.raceResult.recomputeRaceStatistics();
        this.getResultsChangedHolder().setValue(true);
        this.mustRecomputeStandings = true;
    }

    public void updateRacerResultSecondRun(RaceEntryResult aRacerResult, CompetitorResultValue<?> runResultValue) {
        ((RaceEntryResult2Run)aRacerResult).updateSecondRun(runResultValue);
        this.getRaceResultTableHolder().refreshRow(aRacerResult);
        this.raceResult.recomputeRaceStatistics();
        this.getResultsChangedHolder().setValue(true);
        this.mustRecomputeStandings = true;
    }
}

