/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.ui.RacerListReconciliationResult;

public class RaceResultReconcilationResult
extends RacerListReconciliationResult {
    private RaceResult raceResult;
    private List<RacerResult> inconsistentBibRacers;
    private List<RacerResult> maybeProblemRacers;

    public static RaceResultReconcilationResult reconcileCompetitors(RaceResult raceResult, ToolSessionRacerList racerList) {
        RaceResultReconcilationResult reconciliationResult = new RaceResultReconcilationResult(raceResult, racerList);
        reconciliationResult.reconcileCompetitors();
        return reconciliationResult;
    }

    public RaceResultReconcilationResult(RaceResult raceResult, ToolSessionRacerList racerList) {
        super(racerList);
        this.raceResult = raceResult;
        this.initCompetitorProcessingParms();
    }

    public List<RacerResult> getInconsistentBibRacers() {
        return this.inconsistentBibRacers;
    }

    public List<RacerResult> getMaybeProblemRacers() {
        return this.maybeProblemRacers;
    }

    public RaceResult getRaceResult() {
        return this.raceResult;
    }

    protected void initCompetitorProcessingParms() {
        Class<? extends RaceClass<?>> raceClassClass = this.raceResult.getRaceClassClass();
        this.initAbilityGroupReferences(raceClassClass);
    }

    @Override
    protected void initReconciliationInfo() {
        super.initReconciliationInfo();
        this.inconsistentBibRacers = new ArrayList<RacerResult>();
        this.maybeProblemRacers = new ArrayList<RacerResult>();
    }

    @Override
    public boolean hasUnreconciledRacers() {
        return super.hasUnreconciledRacers() || this.inconsistentBibRacers.size() > 0 || this.maybeProblemRacers.size() > 0;
    }

    @Override
    protected void processCompetitors() {
        for (RacerResult rr : this.raceResult.getRacerResults()) {
            this.reconcileCompetitor((RaceEntryResult)rr);
        }
    }

    protected void reconcileCompetitor(RaceEntryResult racerResult) {
        String lastName = racerResult.getLastName();
        String firstName = racerResult.getFirstName();
        RaceClass<?> raceClass = racerResult.getRaceClass();
        Racer racerWithThisName = null;
        Racer registeredRacer = this.findRacerWithBibNumber(racerResult.getBibNumber());
        if (registeredRacer != null) {
            boolean hasSameName = this.hasSameName(registeredRacer, lastName, firstName);
            boolean hasProperAgeClass = this.hasSuitableAgeClass(registeredRacer, raceClass);
            if (hasSameName) {
                if (!hasProperAgeClass) {
                    this.recordUnregisteredRacer(racerResult);
                }
            } else {
                racerWithThisName = this.findRacerWithSameName(lastName, firstName, raceClass);
                if (hasProperAgeClass) {
                    if (racerWithThisName != null) {
                        this.recordInconsistentBibRacer(racerResult, racerWithThisName);
                    } else {
                        this.recordInconsistentNameRacer(racerResult, registeredRacer);
                    }
                } else if (racerWithThisName != null) {
                    this.recordInconsistentBibRacer(racerResult, racerWithThisName);
                } else {
                    this.recordUnregisteredRacer(racerResult);
                }
            }
            return;
        }
        Racer racer = registeredRacer = racerWithThisName != null ? racerWithThisName : this.findRacerWithSameName(lastName, firstName, raceClass);
        if (registeredRacer != null) {
            this.recordInconsistentBibRacer(racerResult, registeredRacer);
            return;
        }
        this.recordUnregisteredRacer(racerResult);
    }

    protected void recordInconsistentBibRacer(RaceEntryResult racerResult, Racer registeredRacer) {
        this.inconsistentBibRacers.add(racerResult);
        this.recordInconsistentRacer(racerResult, registeredRacer);
    }

    protected void recordInconsistentNameRacer(RaceEntryResult racerResult, Racer registeredRacer) {
        this.maybeProblemRacers.add(racerResult);
        this.recordInconsistentRacer(racerResult, registeredRacer);
    }
}

