/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.swing.MessageDialog;
import java.awt.Window;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.ui.RaceResultReconcilationModel;
import org.ussamasters.aces.tools.ui.RaceResultReconcilationResult;
import org.ussamasters.aces.tools.ui.RacerListReconciliationResultViewer;

public class RaceResultReconciliationViewer
extends RacerListReconciliationResultViewer {
    protected static final String APPLICATION_TITLE = "Race Result Reconcilation Report";
    protected RaceResultReconcilationResult reconciliationResult;
    protected RaceResultReconcilationModel reconciliationResultModel;

    public static void openOn(RaceResultReconcilationResult reconcilationResult) {
        RaceResultReconciliationViewer aViewer = new RaceResultReconciliationViewer(reconcilationResult);
        aViewer.openWindow();
    }

    public RaceResultReconciliationViewer(RaceResultReconcilationResult reconciliationResult) {
        super((ToolID)null, APPLICATION_TITLE);
        this.reconciliationResult = reconciliationResult;
        this.initializeReconciliationDataModels();
    }

    public RaceIdentifier getRace() {
        return this.reconciliationResult.getRaceResult().getRaceId();
    }

    public RaceResultReconcilationModel getReconciliationResultModel() {
        return this.reconciliationResultModel;
    }

    protected void initializeReconciliationDataModels() {
        this.reconciliationResultModel = new RaceResultReconcilationModel(this.reconciliationResult);
    }

    public boolean hasUnsavedChanges() {
        return this.getReconciliationResultModel().getHasChangesHolder().getValue() || this.getRacerListEditor().getHasChangesHolder().getValue();
    }

    public void saveChanges() throws RaceDataIOException {
        if (!this.hasUnsavedChanges()) {
            return;
        }
        if (this.getRacerListEditor().getHasChangesHolder().getValue()) {
            this.getSessionManager().saveRacerList(this.racerListEditor.getRacerList());
            this.getRacerListEditor().getHasChangesHolder().setValue(false);
        }
        if (this.getReconciliationResultModel().getHasChangesHolder().getValue()) {
            this.getSessionManager().saveRaceResult(this.getReconciliationResultModel().getUpdatedRaceResult());
            this.getReconciliationResultModel().getHasChangesHolder().setValue(false);
        }
    }

    @Override
    protected boolean shouldAllowCloseWindow(Window aWindow) {
        if (this.hasUnsavedChanges()) {
            int answer = MessageDialog.confirmOrCancel("Unsaved Changes", "You have made changes to the results data which have not yet been saved.  Save changes?", aWindow);
            if (answer == 2) {
                return false;
            }
            if (answer == 0) {
                try {
                    this.saveChanges();
                }
                catch (RaceDataIOException ex) {
                    MessageDialog.displayError("Save Failed", "Unable to save changes to racer data: " + ex.getMessage(), aWindow);
                    return false;
                }
            }
        }
        return super.shouldAllowCloseWindow(aWindow);
    }
}

