/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.swing.TableHolder;
import java.util.Vector;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.tools.ui.RaceEntryResultTableRow;

public class RaceResultTableHolder
extends TableHolder {
    protected RaceResult raceResult;
    protected Vector<RaceEntryResultTableRow> resultDataRows;

    public RaceResultTableHolder(RaceResult raceResult) {
        this.setData(raceResult);
    }

    protected void buildRows() {
        Vector<RaceEntryResultTableRow> rows = new Vector<RaceEntryResultTableRow>(this.raceResult.getNumberOfCompetitors());
        for (RacerResult rr : this.raceResult.getRacerResults()) {
            RaceEntryResult aRacer = (RaceEntryResult)rr;
            rows.add(new RaceEntryResultTableRow(aRacer));
        }
        this.resultDataRows = rows;
    }

    public RaceResult getRaceResult() {
        return this.raceResult;
    }

    public RaceEntryResult getSelectedResult() {
        RaceEntryResultTableRow selectedRow = (RaceEntryResultTableRow)this.getSelectedValue();
        return selectedRow == null ? null : selectedRow.getRacerResult();
    }

    @Override
    public int indexOf(Object aValue) {
        return this.indexOf((RaceEntryResult)aValue);
    }

    public int indexOf(RaceEntryResult racerResult) {
        int nRows = this.size();
        Vector<Vector> rows = this.getConcreteDataModel().getDataVector();
        for (int i = 0; i < nRows; ++i) {
            RaceEntryResultTableRow aRow = (RaceEntryResultTableRow)rows.elementAt(i);
            if (!aRow.getRacerResult().equals(racerResult)) continue;
            return i;
        }
        return -1;
    }

    public void refreshRow(RaceEntryResult aRacerResult) {
        int rowIndex = this.indexOf(aRacerResult);
        if (rowIndex == -1) {
            System.out.println("***Result row not found for " + aRacerResult.getName());
            return;
        }
        ((RaceEntryResultTableRow)this.getRow(rowIndex)).refresh();
        this.getConcreteDataModel().fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void removeRow(RaceEntryResult aRacerResult) {
        int rowIndex = this.indexOf(aRacerResult);
        if (rowIndex == -1) {
            System.out.println("***Result row not found for " + aRacerResult.getName());
            return;
        }
        this.remove(rowIndex);
    }

    protected void setData(RaceResult raceResult) {
        this.raceResult = raceResult;
        this.buildRows();
        this.getConcreteDataModel().setDataVector(this.resultDataRows, RaceEntryResultTableRow.getColumnLabels(this.raceResult.getNumberOfRuns()));
    }
}

