/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.RaceIdentifierModel;
import org.ussamasters.aces.tools.ui.ToolUIModelServices;

public class RaceSpecificationModel
extends RaceIdentifierModel {
    protected RaceDescriptor raceSpec;
    protected DefaultComboBoxModel<RaceClassType> raceClassClassModel;
    protected DefaultComboBoxModel<CourseArrangement> courseArrangementModel;

    public static RaceDescriptor newRaceSpecification(SeasonIdentifier season) {
        return RaceSpecificationModel.newRaceSpecification(RaceSpecificationModel.newRaceIdentifier(season));
    }

    public static RaceDescriptor newRaceSpecification(RaceIdentifier raceID) {
        return new RaceDescriptor(raceID, WorkingSetSettings.getCurrent().getRaceClassClass(), WorkingSetSettings.getCurrent().getWorldCupPointsType(), WorkingSetSettings.getCurrent().getStandardCourseArrangement());
    }

    public static RaceDescriptor newRaceSpecification(RaceResult raceResult) {
        return new RaceDescriptor(raceResult.getRaceId(), raceResult.getRaceClassClass(), raceResult.getWorldCupPointsType(), raceResult.getCourseArrangement());
    }

    public RaceSpecificationModel(RaceIdentifier raceID) {
        this(RaceSpecificationModel.newRaceSpecification(raceID));
    }

    public RaceSpecificationModel(RaceDescriptor raceSpec) {
        super(raceSpec.getRaceId(), false);
        this.setRaceSpec(raceSpec);
    }

    public ComboBoxModel<CourseArrangement> getCourseArrangementModel() {
        return this.courseArrangementModel;
    }

    protected RaceDescriptor getOriginalSpec() {
        return this.raceSpec;
    }

    public ComboBoxModel<RaceClassType> getRaceClassClassModel() {
        return this.raceClassClassModel;
    }

    public RaceDescriptor getRaceSpecification() {
        return new RaceDescriptor(this.getRace(), this.getSelectedRaceClassClass(this.getRace().getSeason()), this.getOriginalSpec().getWorldCupPointsType(), this.getSelectedCourseArrangement());
    }

    public CourseArrangement getSelectedCourseArrangement() {
        return (CourseArrangement)this.getCourseArrangementModel().getSelectedItem();
    }

    public Class<? extends RaceClass<?>> getSelectedRaceClassClass(SeasonIdentifier season) {
        RaceClassType raceClassType = this.getSelectedRaceClassType();
        return SeasonConfiguration.getSeasonConfig(season).getRaceClassClass(raceClassType);
    }

    public RaceClassType getSelectedRaceClassType() {
        return (RaceClassType)this.getRaceClassClassModel().getSelectedItem();
    }

    public boolean hasChanges() {
        if (this.isIdentificationEditable()) {
            throw new UnsupportedOperationException("Not yet supported for race id modifications");
        }
        return this.getHasChangesHolder().getValue();
    }

    @Override
    protected void initializeModels() {
        ToolUIModelServices toolUIModelServices = this.getToolUIModelServices();
        super.initializeModels();
        this.initHasChangesHolder();
        this.raceClassClassModel = toolUIModelServices.constructComboBoxListHolder(this.getToolServices().getRaceClassTypesList());
        this.courseArrangementModel = toolUIModelServices.constructComboBoxListHolder(this.getToolServices().getCourseArrangementsList());
        this.raceClassClassModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent event) {
                RaceSpecificationModel.this.selectedRaceClassClass();
            }

            @Override
            public void intervalAdded(ListDataEvent event) {
                RaceSpecificationModel.this.selectedRaceClassClass();
            }

            @Override
            public void intervalRemoved(ListDataEvent event) {
                RaceSpecificationModel.this.selectedRaceClassClass();
            }
        });
        this.courseArrangementModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent event) {
                RaceSpecificationModel.this.selectedCourseArrangement();
            }

            @Override
            public void intervalAdded(ListDataEvent event) {
                RaceSpecificationModel.this.selectedCourseArrangement();
            }

            @Override
            public void intervalRemoved(ListDataEvent event) {
                RaceSpecificationModel.this.selectedCourseArrangement();
            }
        });
    }

    protected void installRaceSpecValues() {
        RaceClassType raceClassType = this.getOriginalSpec().getRaceClassType();
        if (raceClassType != null && !this.getToolServices().isStandardRaceClassType(raceClassType)) {
            this.raceClassClassModel.addElement(raceClassType);
        }
        this.selectRaceClassType(raceClassType);
        this.selectCourseArrangement(this.getOriginalSpec().getCourseArrangement());
        this.getHasChangesHolder().setValue(false);
    }

    protected void selectedCourseArrangement() {
        if (this.getSelectedCourseArrangement() != this.getOriginalSpec().getCourseArrangement()) {
            this.getHasChangesHolder().setValue(true);
        }
    }

    protected void selectedRaceClassClass() {
        if (this.getSelectedRaceClassType() == null) {
            return;
        }
        if (!this.getSelectedRaceClassType().equals(this.getOriginalSpec().getRaceClassClass())) {
            this.getHasChangesHolder().setValue(true);
        }
    }

    public void selectCourseArrangement(CourseArrangement courseArrangement) {
        this.courseArrangementModel.setSelectedItem(courseArrangement);
    }

    public void selectRaceClassType(RaceClassType raceClassType) {
        this.raceClassClassModel.setSelectedItem(raceClassType);
    }

    protected void setRaceSpec(RaceDescriptor raceSpec) {
        this.raceSpec = raceSpec;
        this.installRaceSpecValues();
    }
}

