/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.swing.TableRow;
import java.util.Vector;
import org.ussamasters.aces.racedata.models.RaceIdentifier;

public class RaceTableRow
extends TableRow {
    public static final int COLUMN_RACE_DATE = 0;
    public static final int COLUMN_RACE_LOCATION = 1;
    public static final int COLUMN_RACE_TYPE = 2;
    public static final int COLUMN_RACE_MODIFIER = 3;
    public static final int NUM_FIXED_COLUMNS = 4;
    public static final String[] STANDARD_FIXED_COLUMN_NAMES = new String[]{"Date", "Location", "Type", "Qualifier"};
    public static final Vector<String> STANDARD_FIXED_COLUMN_LABELS = RaceTableRow.constructColumnLabels(new String[0]);
    protected static final String[] NO_OTHER_VALUES = new String[0];
    protected RaceIdentifier race;
    protected Object[] variableValues;

    protected static <E> void appendValues(Vector<E> theList, int startIndex, E[] values) {
        for (int i = 0; i < values.length; ++i) {
            theList.add(values[i]);
        }
    }

    public static Vector<String> constructColumnLabels(String additionalInfoLabel) {
        return RaceTableRow.constructColumnLabels(new String[]{additionalInfoLabel});
    }

    public static Vector<String> constructColumnLabels(String[] additionalLabels) {
        Vector<String> labels = new Vector<String>(4 + additionalLabels.length);
        RaceTableRow.appendValues(labels, 0, STANDARD_FIXED_COLUMN_NAMES);
        RaceTableRow.appendValues(labels, 4, additionalLabels);
        return labels;
    }

    public RaceTableRow(RaceIdentifier aRace) {
        this(aRace, NO_OTHER_VALUES);
    }

    public RaceTableRow(RaceIdentifier aRace, String additionalValue) {
        this(aRace, new String[]{additionalValue});
    }

    public RaceTableRow(RaceIdentifier aRace, Object[] otherInfo) {
        super(aRace, 4 + otherInfo.length);
        this.race = aRace;
        this.variableValues = otherInfo;
        this.setColumnValues();
    }

    public RaceIdentifier getRace() {
        return this.race;
    }

    public void refresh() {
        this.setColumnValues();
    }

    protected void setColumnValues() {
        Vector<Object> columnValues = new Vector<Object>(4 + this.variableValues.length);
        columnValues.add(0, this.race.getDate().toStandardString());
        columnValues.add(1, this.race.getLocation().fullName);
        columnValues.add(2, "" + this.race.getType().name);
        columnValues.add(3, this.race.getQualifier() == null ? "" : this.race.getQualifier());
        for (int i = 0; i < this.variableValues.length; ++i) {
            columnValues.add(this.variableValues[i]);
        }
        this.setColumnValues(columnValues);
    }
}

