/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.BooleanHolder;
import java.awt.Frame;
import java.awt.Window;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManager;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.ui.RaceDataTool;
import org.ussamasters.aces.tools.ui.RacerListEditorModel;

public class RacerListEditor
extends RaceDataTool
implements RacerListManager {
    public static final ToolID TOOL_ID = new ToolID("RacerListEditor");
    protected static String APPLICATION_TITLE = "Racer List Editor";
    private static final Class<RacerListEditor> THIS_CLASS = RacerListEditor.class;
    private static final EvaluableAction TOOL_CONSTRUCTION_ACTION = RacerListEditor.constructToolConstructionAction(THIS_CLASS);
    protected static int racerListSortOrder = 0;
    protected RacerListEditorModel racerListEditor;

    public static ApplicationView findOrOpen() {
        ApplicationView aWindow = RacerListEditor.findWindow(TOOL_ID);
        if (aWindow != null) {
            Frame frameWindow = (Frame)aWindow.getMainWindow();
            if (frameWindow.getState() == 1) {
                frameWindow.setState(0);
            } else {
                frameWindow.toFront();
            }
            frameWindow.requestFocus();
        } else {
            aWindow = RacerListEditor.open();
        }
        return aWindow;
    }

    public static void installTool(ToolInfo toolInfo) {
        String displayName = toolInfo.getDisplayName();
        if (displayName != null) {
            APPLICATION_TITLE = displayName;
        }
    }

    public static boolean isOpen() {
        return RacerListEditor.findWindow(TOOL_ID) != null;
    }

    public static ApplicationView open() {
        return RacerListEditor.openToolWindow(TOOL_ID, TOOL_CONSTRUCTION_ACTION);
    }

    public RacerListEditor() {
        super(TOOL_ID, APPLICATION_TITLE);
    }

    public BooleanHolder getHasChangesHolder() {
        return this.racerListEditor.getHasChangesHolder();
    }

    public RacerListEditorModel getRacerListEditor() {
        return this.racerListEditor;
    }

    public boolean hasUnsavedChanges() {
        return this.racerListEditor.hasUnsavedChanges();
    }

    @Override
    protected void initializeModels() {
        super.initializeModels();
        this.racerListEditor = new RacerListEditorModel(this.getSessionManager().getRacerListForEdit(), racerListSortOrder);
    }

    public void saveChanges() throws RaceDataIOException {
        this.getSessionManager().saveRacerList(this.racerListEditor.getRacerList());
        this.getHasChangesHolder().setValue(false);
    }

    @Override
    protected boolean shouldAllowCloseWindow(Window aWindow) {
        if (this.hasUnsavedChanges()) {
            int answer = MessageDialog.confirmOrCancel("Unsaved Changes", "You have made changes to the racer list which have not yet been saved.  Save changes?", aWindow);
            if (answer == 2) {
                return false;
            }
            if (answer == 0) {
                try {
                    this.saveChanges();
                }
                catch (RaceDataIOException ex) {
                    MessageDialog.displayError("Save Failed", "Unable to save changes to racer data: " + ex.getMessage(), aWindow);
                    return false;
                }
            }
        }
        return super.shouldAllowCloseWindow(aWindow);
    }

    @Override
    public void updateManagementPolicy(RacerListManagementPolicy managementPolicy) {
        this.racerListEditor.getRacerList().setManagementPolicy(managementPolicy);
    }

    @Override
    protected void windowClosed(Window aWindow) {
        racerListSortOrder = this.racerListEditor.getRacerListHolder().getSortOrder();
        super.windowClosed(aWindow);
    }

    @Override
    protected void windowOpened(Window aWindow) {
        super.windowOpened(aWindow);
    }

    public static void main(String[] args) {
        RacerListEditor.processCommandLineArgs(args);
        RacerListEditor.initiateSession();
        RacerListEditor.open();
    }
}

