/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.util.StatusValue;
import com.glaivestone.mv.ApplicationView;
import java.awt.Frame;
import org.ussamasters.aces.racedata.interchange.TimingSystemDataImporter;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.RaceCompetitorsReconcilationResult;
import org.ussamasters.aces.tools.ui.RaceCompetitorsReconciliationViewer;
import org.ussamasters.aces.tools.ui.RaceDataTool;
import org.ussamasters.aces.tools.ui.TimingDataImportModel;

public class RacerListImportTool
extends RaceDataTool {
    public static final ToolID TOOL_ID = new ToolID("RacerListImportTool");
    protected static final String APPLICATION_TITLE = "Load Racers";
    private static final Class<RacerListImportTool> THIS_CLASS = RacerListImportTool.class;
    private static final EvaluableAction TOOL_CONSTRUCTION_ACTION = RacerListImportTool.constructToolConstructionAction(THIS_CLASS);
    protected TimingDataImportModel timingDataImportModel;

    public static ApplicationView findOrOpen() {
        ApplicationView aWindow = RacerListImportTool.findWindow(TOOL_ID);
        if (aWindow != null) {
            Frame frameWindow = (Frame)aWindow.getMainWindow();
            if (frameWindow.getState() == 1) {
                frameWindow.setState(0);
            } else {
                frameWindow.toFront();
            }
            frameWindow.requestFocus();
        } else {
            aWindow = RacerListImportTool.open();
        }
        return aWindow;
    }

    public static ApplicationView open() {
        return (ApplicationView)((Object)new RacerListImportTool().openWindow());
    }

    public RacerListImportTool() {
        super(TOOL_ID, APPLICATION_TITLE);
    }

    public TimingDataImportModel getTimingDataImportModel() {
        return this.timingDataImportModel;
    }

    public RacerList importRacerListData(boolean processNonStarters) throws RaceDataIOException {
        TimingSystemDataImporter loader = this.getTimingDataImportModel().importRacerList(processNonStarters);
        RacerList competitorList = loader.getCompetitorList();
        return competitorList;
    }

    public StatusValue importRacerListDataAndReconcile(boolean processNonStarters) throws RaceDataIOException {
        TimingSystemDataImporter loader = this.getTimingDataImportModel().importRacerList(processNonStarters);
        RacerList competitorList = loader.getCompetitorList();
        if (competitorList == null || competitorList.size() == 0) {
            return new StatusValue(1, "No racer data found.");
        }
        RaceCompetitorsReconcilationResult reconciliationResult = RaceCompetitorsReconcilationResult.reconcileCompetitors(competitorList, this.getSessionManager().getRacerList());
        if (!reconciliationResult.hasUnreconciledRacers()) {
            return new StatusValue(2, "All racers are already registered in the race series racer list.");
        }
        RaceCompetitorsReconciliationViewer.openOn(loader.getRaceSpecification().getRaceId(), reconciliationResult);
        return StatusValue.SUCCESS_RESULT;
    }

    @Override
    protected void initializeModels() {
        super.initializeModels();
        this.timingDataImportModel = new TimingDataImportModel(this.getSessionManager().getRacerList().getAgeClassClass());
    }

    public ValidationResult validateImportRequest() {
        ValidationResult validationResult = new ValidationResult();
        this.timingDataImportModel.validateSpecifications(validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        return ValidationResult.SUCCESS_RESULT;
    }
}

