/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.devx.DebugSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassHelper;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.USSALicense;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.foundation.processors.RacerNameChecker;

public abstract class RacerListReconciliationResult {
    private final ToolSessionRacerList racerList;
    private final SeasonIdentifier season;
    protected final RaceClassHelper raceClassHelper;
    private List<Object> unregisteredRacers;
    private Map<Object, Racer> candidateMatchTable;

    protected RacerListReconciliationResult(ToolSessionRacerList racerList) {
        this.racerList = racerList;
        this.season = racerList.getSeason();
        this.raceClassHelper = new RaceClassHelper(this.season);
    }

    protected Racer findRacerWithBibNumber(int bibNumber) {
        return this.racerList.findBib(bibNumber);
    }

    protected Racer findRacerWithSameName(String lastName, String firstName, RaceClass<?> raceClass) {
        List<Racer> matchingRacers = RacerNameChecker.getCurrent().getAllRacersWithSameName(this.racerList, lastName, firstName, raceClass);
        if (matchingRacers.size() == 0) {
            return null;
        }
        if (matchingRacers.size() > 1) {
            DebugSupport.current().dump("Probably duplicate racer entries for " + firstName + " " + lastName + " in " + raceClass);
            for (Racer aRacer : matchingRacers) {
                DebugSupport.current().dump("..." + aRacer.getBib() + " - " + aRacer.getName());
            }
            DebugSupport.current().dump("(" + matchingRacers.size() + " racer entries with equivalent name");
        }
        return matchingRacers.get(0);
    }

    protected Racer findRacerWithUSSANumber(String ussaNumber) {
        return this.racerList.findUSSANumber(ussaNumber);
    }

    public Racer getRegisteredRacerCandidateMatch(Object racerInfo) {
        return this.candidateMatchTable.get(racerInfo);
    }

    protected ToolSessionRacerList getRacerList() {
        return this.racerList;
    }

    public List<Object> getUnregisteredRacers() {
        return this.unregisteredRacers;
    }

    public boolean hasUnreconciledRacers() {
        return this.hasUnregisteredRacers();
    }

    public boolean hasUnregisteredRacers() {
        return this.getUnregisteredRacers().size() > 0;
    }

    protected boolean hasSameFirstName(Racer registeredRacer, String firstName) {
        return RacerNameChecker.getCurrent().sameFirstName(registeredRacer, firstName);
    }

    protected boolean hasSameLastName(Racer registeredRacer, String lastName) {
        return RacerNameChecker.getCurrent().sameLastName(registeredRacer, lastName);
    }

    protected boolean hasSameName(Racer registeredRacer, String lastName, String firstName) {
        return this.hasSameLastName(registeredRacer, lastName) && this.hasSameFirstName(registeredRacer, firstName);
    }

    protected boolean hasSameUSSANumber(Racer registeredRacer, String ussaNumber) {
        String racerUSSANumber = registeredRacer.getUSSALicense().toString();
        if (USSALicense.isValid(racerUSSANumber)) {
            return USSALicense.isValid(ussaNumber) && racerUSSANumber.toUpperCase().equals(ussaNumber.toUpperCase());
        }
        return !USSALicense.isValid(ussaNumber);
    }

    protected boolean hasSuitableAgeClass(Racer registeredRacer, RaceClass<?> raceClass) {
        if (raceClass.isAbilityGroupClass()) {
            return true;
        }
        RaceClass<?> ageClass = registeredRacer.getAgeClass();
        if (ageClass == raceClass) {
            return true;
        }
        if (raceClass.isNationalClass() && ageClass.isDivisionClass()) {
            RaceClass<?> nationalClass = registeredRacer.getNationalClass();
            if (!nationalClass.isUnknown()) {
                return nationalClass == raceClass;
            }
            RaceClass<?> expectedAgeClass = this.raceClassHelper.toDivisionAgeClass(raceClass, ageClass.getClass());
            return ageClass == expectedAgeClass;
        }
        return false;
    }

    protected void initAbilityGroupReferences(Class<? extends RaceClass<?>> raceClassClass) {
    }

    protected void initReconciliationInfo() {
        this.unregisteredRacers = new ArrayList<Object>();
        this.candidateMatchTable = new HashMap<Object, Racer>();
    }

    protected abstract void processCompetitors();

    public void reconcileCompetitors() {
        this.initReconciliationInfo();
        this.processCompetitors();
    }

    protected void recordInconsistentRacer(Object racerInfo, Racer registeredRacer) {
        this.candidateMatchTable.put(racerInfo, registeredRacer);
    }

    protected void recordUnregisteredRacer(Object racerInfo) {
        this.unregisteredRacers.add(racerInfo);
    }
}

