/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.swing.TableRow;
import java.util.Arrays;
import java.util.Vector;
import org.ussamasters.aces.racedata.models.Racer;

public class RacerTableRow
extends TableRow {
    public static final Vector<String> COLUMN_NAMES = RacerTableRow.asVector(RacerTableRow.constructColumnNames());
    public static final Vector<String> STANDARD_COLUMN_LABELS = RacerTableRow.asVector(RacerTableRow.constructColumnLabels());
    public static final int[] STANDARD_COLUMN_WIDTHS = RacerTableRow.constructColumnWidths();
    public static final int COLUMN_LAST_NAME = 0;
    public static final int COLUMN_FIRST_NAME = 1;
    public static final int COLUMN_BIB_NUMBER = 2;
    public static final int COLUMN_AGE_CLASS = 3;
    public static final int COLUMN_YEAR_BORN = 4;
    public static final int COLUMN_AFFILIATION = 5;
    public static final int COLUMN_USSA_NUMBER = 6;
    public static final int COLUMN_TEAM = 7;
    public static final int NUM_COLUMNS = 8;
    protected Racer racer;

    public static Vector<String> asVector(String[] values) {
        return new Vector<String>(Arrays.asList(values));
    }

    public RacerTableRow(Racer aRacer) {
        super(aRacer, 8);
        this.racer = aRacer;
        this.setColumnValues();
    }

    public Racer getRacer() {
        return this.racer;
    }

    public void refresh() {
        this.setColumnValues();
    }

    protected void setColumnValues() {
        Object[] columnValues = new String[8];
        columnValues[0] = this.racer.getLastName();
        columnValues[1] = this.racer.getFirstName();
        columnValues[2] = this.racer.getBib();
        columnValues[3] = this.racer.getAgeClass().name;
        columnValues[4] = this.racer.isBirthYearKnown() ? "" + this.racer.getBirthYear() : "";
        columnValues[5] = this.racer.getAffiliation().abbreviation;
        columnValues[6] = this.racer.getUSSALicense().toString();
        this.setColumnValues(columnValues);
    }

    protected static String[] constructColumnLabels() {
        String[] labels = new String[]{"Last Name", "First Name", "Bib", "Class", "Year Born", "Affiliation", "USSANumber", "Team"};
        return labels;
    }

    protected static String[] constructColumnNames() {
        String[] names = new String[]{"lastName", "firstName", "bibNumber", "ageClass", "yearBorn", "affiliation", "ussaNumber", "team"};
        return names;
    }

    protected static int[] constructColumnWidths() {
        int[] widths = new int[]{125, 75, 40, 40, 60, 50, 100, 100};
        return widths;
    }
}

