/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.execution.OneArgumentBlock;
import com.glaivestone.mv.IntegerHolder;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.tools.foundation.models.RaceDataComponentModel;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.RaceCompetitorsReconcilationResult;
import org.ussamasters.aces.tools.ui.RaceCompetitorsReconciliationViewer;
import org.ussamasters.aces.tools.ui.RaceResultBibMappingReconciliationResult;
import org.ussamasters.aces.tools.ui.RaceSeriesTableHolder;
import org.ussamasters.aces.tools.ui.SeriesScoringTool;

public class ScoredRaceSeriesModel
extends RaceDataComponentModel {
    protected RaceSeries raceSeries;
    protected SeriesScoringTool owner;
    protected RaceSeriesTableHolder raceSeriesTableHolder;
    protected IntegerHolder numberOfRacesHolder;

    public ScoredRaceSeriesModel(RaceSeries raceSeries, SeriesScoringTool owner) {
        this.raceSeries = raceSeries;
        this.owner = owner;
        this.initializeModels();
    }

    public void addRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.owner.addRace(raceID);
        this.getRaceSeriesTableHolder().addRace(raceID);
        this.getNumberOfRacesHolder().setValue(this.raceSeries.size());
        this.completeAddRace(raceID);
    }

    protected void completeAddRace(RaceIdentifier raceID) throws RaceDataIOException {
        RaceCompetitorsReconcilationResult reconciliationResult;
        RacerList raceCompetitorsList;
        if (this.getSessionManager().isResultReconciled(raceID)) {
            return;
        }
        try {
            raceCompetitorsList = this.getSessionManager().getRaceResultCompetitorInfo(raceID);
        }
        catch (RaceDataIOException ex) {
            DebugSupport.current().dump("Error loading race result competitor data for " + raceID);
            DebugSupport.current().dumpStack(ex);
            raceCompetitorsList = null;
        }
        PolicyID mergePolicy = this.getSessionManager().getRacerListMergePolicy();
        if (mergePolicy == WorkingSetSettings.MAP_ON_DEFINITE_MATCH_RACER_LIST_MERGE_POLICY) {
            RaceResult seriesResult = this.getSessionManager().getRaceResult(raceID);
            RaceResultBibMappingReconciliationResult reconcilationResult = RaceResultBibMappingReconciliationResult.reconcileCompetitors(seriesResult, raceCompetitorsList, this.getSessionManager().getRacerList());
            int nBibChanges = 0;
            for (RacerResult rr : reconcilationResult.getInconsistentBibRacers()) {
                RaceEntryResult racerResult = (RaceEntryResult)rr;
                Racer registeredRacer = reconcilationResult.getRegisteredRacerCandidateMatch(racerResult);
                int raceBibNumber = racerResult.getBibNumber();
                int seriesBibNumber = registeredRacer.getBibNumber();
                racerResult.setBibNumber(seriesBibNumber);
                if (raceCompetitorsList != null) {
                    Racer raceCompetitor = raceCompetitorsList.findBib(raceBibNumber);
                    raceCompetitor.setBibNumber(seriesBibNumber);
                    raceCompetitorsList.update(raceCompetitor);
                }
                ++nBibChanges;
            }
            if (nBibChanges > 0) {
                DebugSupport.current().dump("\n**NOTE: Automatic bib mapping update for new series race applied to " + nBibChanges + " racers in " + raceID + "\n");
                this.getSessionManager().saveRaceResult(seriesResult);
            }
        }
        if (raceCompetitorsList != null && (reconciliationResult = RaceCompetitorsReconcilationResult.reconcileCompetitors(raceCompetitorsList, this.getSessionManager().getRacerList())).hasUnreconciledRacers()) {
            RaceCompetitorsReconciliationViewer.openOn(raceID, reconciliationResult);
        }
        this.getSessionManager().markResultReconciled(raceID);
    }

    protected RaceSeries constructCandidateRaceAdditionsList(boolean mustHaveDataAvailable) {
        RaceSeries candidateRaces = RaceSeries.createEmptySeries(this.getRaceSeries());
        for (RaceIdentifier raceID : this.getSessionManager().getRaceCalendar().getRaces()) {
            if (this.getRaceSeries().contains(raceID) || mustHaveDataAvailable && this.getSessionManager().getRaceResult(raceID) == null) continue;
            candidateRaces.add(raceID);
        }
        return candidateRaces;
    }

    public RaceSeries getCandidateRaceAdditions() {
        return this.constructCandidateRaceAdditionsList(true);
    }

    public IntegerHolder getNumberOfRacesHolder() {
        return this.numberOfRacesHolder;
    }

    public RaceResult getRaceResult(RaceIdentifier aRace) {
        if (aRace == null) {
            return null;
        }
        return this.getSessionManager().getRaceResult(aRace);
    }

    public RaceSeries getRaceSeries() {
        return this.raceSeries;
    }

    public RaceSeriesTableHolder getRaceSeriesTableHolder() {
        return this.raceSeriesTableHolder;
    }

    protected String getRaceStatusDescription(RaceIdentifier raceID) {
        RaceResult aRaceResult = this.getRaceResult(raceID);
        return aRaceResult == null ? "" : aRaceResult.getNumberOfCompetitors() + " competitors; " + aRaceResult.getNumberOfFinishers() + " finishers";
    }

    public RaceIdentifier getSelectedRace() {
        return this.getRaceSeriesTableHolder().getSelectedRace();
    }

    public RaceResult getSelectedRaceResult() {
        return this.getRaceResult(this.getSelectedRace());
    }

    protected void initializeModels() {
        this.raceSeriesTableHolder = new RaceSeriesTableHolder(this.raceSeries, "Summary", new OneArgumentBlock(this, "ComposeRaceStatusEntry"){

            @Override
            protected Object evaluateExpression(Object aValue) {
                return ScoredRaceSeriesModel.this.getRaceStatusDescription((RaceIdentifier)aValue);
            }
        });
        this.numberOfRacesHolder = new IntegerHolder(this.raceSeries.size());
    }

    public void removeRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.owner.removeRace(raceID);
        this.getRaceSeriesTableHolder().removeRace(raceID);
        this.getNumberOfRacesHolder().setValue(this.raceSeries.size());
    }

    protected void setRaceSeries(RaceSeries raceSeries) {
        this.raceSeries = raceSeries;
        this.getRaceSeriesTableHolder().setData(raceSeries);
        this.getNumberOfRacesHolder().setValue(raceSeries.size());
    }
}

