/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.ussamasters.aces.tools.foundation.models.RaceScoringSessionManager;
import org.ussamasters.aces.tools.ui.ChooseRaceDialog;
import org.ussamasters.aces.tools.ui.RaceDataTool;
import org.ussamasters.aces.tools.ui.RaceSeriesChoiceDialog;
import org.ussamasters.aces.tools.ui.swing.OKCancelButtonsPanel;
import org.ussamasters.aces.tools.ui.swing.RSTDialogWindow;

public class ChooseRaceDialogWindow
extends RSTDialogWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 5865.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 5250.0f;
    protected JScrollPane racesListScrollPane;
    protected JTable racesListTablePane;
    protected OKCancelButtonsPanel operationButtonsPanel;

    public ChooseRaceDialogWindow() {
    }

    public ChooseRaceDialogWindow(Dialog arg1) {
        super(arg1);
    }

    public ChooseRaceDialogWindow(Frame arg1) {
        super(arg1);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.setTitle("Choose Race");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initRacesListTablePane();
        this.initOperationButtonsPanel();
    }

    protected void initRacesListTablePane() {
        this.racesListScrollPane = new JScrollPane();
        this.racesListScrollPane.setName("racesListScrollPane");
        FramerFactory.current.installComponent(this.racesListScrollPane, this.contentPanel, 1, 170, 0.0f, 0.0f, 0.0f, 510.0f);
        this.racesListTablePane = new JTable();
        this.racesListTablePane.setName("racesListTablePane");
        this.racesListScrollPane.setViewportView(this.racesListTablePane);
    }

    protected void initOperationButtonsPanel() {
        this.operationButtonsPanel = new OKCancelButtonsPanel();
        this.operationButtonsPanel.setName("operationButtonsPanel");
        FramerFactory.current.installComponent(this.operationButtonsPanel, this.contentPanel, this.operationButtonsPanel.bottomCenterFramingSpec());
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1050.0f, 990.0f, 5865.0f, 5250.0f);
    }

    protected RaceSeriesChoiceDialog myApp() {
        return (RaceSeriesChoiceDialog)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.racesListTablePane.setModel(this.myApp().getRacesListHolder().getDataModel());
        this.racesListTablePane.setSelectionModel(this.myApp().getRacesListHolder().getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.racesListTablePane);
        this.configureConnections();
    }

    protected void configureConnections() {
        this.myToolServices().registerDoubleClickHandler((JComponent)this.racesListTablePane, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChooseRaceDialogWindow.this.myApp().acceptResult();
                ChooseRaceDialogWindow.this.requestCloseWindow();
            }
        });
        this.operationButtonsPanel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChooseRaceDialogWindow.this.myApp().acceptResult();
                ChooseRaceDialogWindow.this.requestCloseWindow();
            }
        });
        this.operationButtonsPanel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChooseRaceDialogWindow.this.requestCloseWindow();
            }
        });
    }

    public static void main(String[] args) {
        try {
            RaceDataTool.initiateSession();
        }
        catch (Exception ex) {
            System.out.println("***SESSION INITIATION ERROR: " + ex.getMessage());
            System.exit(0);
        }
        RaceScoringSessionManager.current.closeSplashScreen();
        ChooseRaceDialog appModel = new ChooseRaceDialog(RaceScoringSessionManager.current.getRaceCalendar(), null);
        appModel.openWindow(new ChooseRaceDialogWindow());
        System.out.println("\nSelected " + appModel.getSelectedRace());
    }
}

