/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.tools.foundation.models.RaceScoringSessionManager;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.swing.UserConfirmationValidationResolver;
import org.ussamasters.aces.tools.ui.EditRaceIdentifierDialog;
import org.ussamasters.aces.tools.ui.RaceDataTool;
import org.ussamasters.aces.tools.ui.swing.OKCancelButtonsPanel;
import org.ussamasters.aces.tools.ui.swing.RSTDialogWindow;
import org.ussamasters.aces.tools.ui.swing.RaceIdentifierPanel;

public class EditRaceIdentifierDialogWindow
extends RSTDialogWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 6225.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 3360.0f;
    protected RaceIdentifierPanel raceIdentifierPanel;
    protected OKCancelButtonsPanel operationButtonsPanel;

    public EditRaceIdentifierDialogWindow() {
    }

    public EditRaceIdentifierDialogWindow(Dialog arg1) {
        super(arg1);
    }

    public EditRaceIdentifierDialogWindow(Frame arg1) {
        super(arg1);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.dialogWindow.setTitle("Edit Race");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initRaceIdentifierPanel();
        this.initOperationButtonsPanel();
    }

    protected void initRaceIdentifierPanel() {
        this.raceIdentifierPanel = new RaceIdentifierPanel();
        this.raceIdentifierPanel.init();
        FramerFactory.current.installComponent(this.raceIdentifierPanel, this.contentPanel, 1, 170, 0.0f, 0.0f, 0.0f, 510.0f);
    }

    protected void initOperationButtonsPanel() {
        this.operationButtonsPanel = new OKCancelButtonsPanel();
        this.operationButtonsPanel.setName("operationButtonsPanel");
        FramerFactory.current.installComponent(this.operationButtonsPanel, this.contentPanel, this.operationButtonsPanel.bottomCenterFramingSpec());
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 2385.0f, 1740.0f, 6225.0f, 3360.0f);
    }

    protected EditRaceIdentifierDialog myApp() {
        return (EditRaceIdentifierDialog)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.dialogWindow.setTitle(this.myApp().getTitle());
        this.raceIdentifierPanel.setModel(this.myApp().getRaceIdentifierModel());
        this.configureConnections();
    }

    protected void configureConnections() {
        this.operationButtonsPanel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (EditRaceIdentifierDialogWindow.this.acceptChanges()) {
                    EditRaceIdentifierDialogWindow.this.requestCloseWindow();
                }
            }
        });
        this.operationButtonsPanel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditRaceIdentifierDialogWindow.this.requestCloseWindow();
            }
        });
    }

    protected boolean acceptChanges() {
        if (!this.myApp().hasChanges()) {
            return true;
        }
        UserConfirmationValidationResolver validationResolver = this.myToolServices().constructUserConfirmationValidationResolver(this.dialogWindow);
        ValidationResult validationResult = this.myApp().validateChanges(validationResolver);
        if (validationResult.failed()) {
            if (validationResolver.numberOfDenials == 0) {
                MessageDialog.displayWarning("Invalid Race Identifier", validationResult.getMessage(), this.dialogWindow);
            }
            return false;
        }
        try {
            this.myApp().acceptChanges();
        }
        catch (RuntimeException ex) {
            DebugSupport.current().dumpStack(ex);
            MessageDialog.displayError("Error Saving Changes", "Unable to save race identifier changes: " + ex.getMessage(), this.dialogWindow);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            RaceDataTool.initiateSession();
        }
        catch (Exception ex) {
            System.out.println("***SESSION INITIATION ERROR: " + ex.getMessage());
            System.exit(0);
        }
        RaceScoringSessionManager.current.closeSplashScreen();
        SeasonConfiguration seasonConfig = SeasonConfiguration.getCurrentSeasonConfig();
        RaceSeries dummyRaceSeries = RaceSeries.createEmptySeries("Fake Race Series", seasonConfig.getSeason(), seasonConfig.getRaceClassClass(RaceClassType.us_masters), WorldCupPointsType.DEFAULT);
        EditRaceIdentifierDialog appModel = new EditRaceIdentifierDialog(dummyRaceSeries.getSeason(), null, dummyRaceSeries, null);
        appModel.openWindow(new EditRaceIdentifierDialogWindow());
        System.out.println("GOT RESULT: " + appModel.getNewRaceIdentifier());
    }
}

