/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.SwingPatches;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.swing.UserConfirmationValidationResolver;
import org.ussamasters.aces.tools.ui.EditRacerDataDialog;
import org.ussamasters.aces.tools.ui.swing.OKCancelButtonsPanel;
import org.ussamasters.aces.tools.ui.swing.RSTDialogWindow;

public class EditRacerDataDialogWindow
extends RSTDialogWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 6570.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 4835.0f;
    protected Map<String, Object> propertyValueItemMap;
    protected JLabel lastNameLabel;
    protected JTextField lastNameField;
    protected JLabel firstNameLabel;
    protected JTextField firstNameField;
    protected JLabel bibNumberLabel;
    protected JTextField bibNumberField;
    protected JButton nextBibNumberButton;
    protected JLabel ageClassLabel;
    protected JComboBox<RaceClass<?>> ageClassComboBox;
    protected JLabel ussaClassLabel;
    protected JComboBox<RaceClass<?>> ussaClassComboBox;
    protected JLabel yearBornLabel;
    protected JTextField yearBornField;
    protected JLabel affiliationLabel;
    protected JComboBox<RaceOrganization> affiliationComboBox;
    protected JLabel ussaNumberLabel;
    protected JTextField ussaNumberField;
    protected OKCancelButtonsPanel operationButtonsPanel;

    public EditRacerDataDialogWindow() {
    }

    public EditRacerDataDialogWindow(Dialog arg1) {
        super(arg1);
    }

    public EditRacerDataDialogWindow(Frame arg1) {
        super(arg1);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.dialogWindow.setTitle("Edit Racer Data");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    public void initChildComponents() {
        this.initLastNameItems();
        this.initFirstNameItems();
        this.initBibNumberItems();
        this.initRaceClassItems();
        this.initYearBornItems();
        this.initAffiliationItems();
        this.initUssaNumberItems();
        this.initTeamItems();
        this.initOperationButtonsPanel();
    }

    protected void initLastNameItems() {
        this.lastNameLabel = new JLabel();
        this.lastNameLabel.setName("lastNameLabel");
        this.lastNameLabel.setText("Last Name");
        FramerFactory.current.installComponent(this.lastNameLabel, this.contentPanel, 1, 136, 0.0f, 0.0f, 1065.0f, 315.0f);
        this.lastNameField = new JTextField();
        this.lastNameField.setName("lastNameField");
        this.lastNameField.setColumns(10);
        FramerFactory.current.installComponent(this.lastNameField, this.contentPanel, 1, 168, 1170.0f, 0.0f, 0.0f, 315.0f);
    }

    protected void initFirstNameItems() {
        this.firstNameLabel = new JLabel();
        this.firstNameLabel.setName("firstNameLabel");
        this.firstNameLabel.setText("First Name");
        FramerFactory.current.installComponent(this.firstNameLabel, this.contentPanel, 1, 136, 0.0f, 435.0f, 1065.0f, 315.0f);
        this.firstNameField = new JTextField();
        this.firstNameField.setName("firstNameField");
        this.firstNameField.setColumns(10);
        FramerFactory.current.installComponent(this.firstNameField, this.contentPanel, 1, 168, 1170.0f, 435.0f, 0.0f, 315.0f);
    }

    protected void initBibNumberItems() {
        this.bibNumberLabel = new JLabel();
        this.bibNumberLabel.setName("bibNumberLabel");
        this.bibNumberLabel.setText("Bib Number");
        FramerFactory.current.installComponent(this.bibNumberLabel, this.contentPanel, 1, 136, 0.0f, 870.0f, 1095.0f, 315.0f);
        this.bibNumberField = new JTextField();
        this.bibNumberField.setName("bibNumberField");
        this.bibNumberField.setColumns(10);
        FramerFactory.current.installComponent(this.bibNumberField, this.contentPanel, 1, 136, 1170.0f, 825.0f, 915.0f, 315.0f);
        this.nextBibNumberButton = new JButton();
        this.nextBibNumberButton.setName("nextBibNumberButton");
        this.nextBibNumberButton.setText("Next Available Bib...");
        this.nextBibNumberButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.nextBibNumberButton, this.contentPanel, 1, 40, 1770.0f, 825.0f, 0.0f, 315.0f);
    }

    protected void initRaceClassItems() {
        this.ageClassLabel = new JLabel();
        this.ageClassLabel.setName("ageClassLabel");
        this.ageClassLabel.setText("Age Class");
        FramerFactory.current.installComponent(this.ageClassLabel, this.contentPanel, 1, 136, 0.0f, 1305.0f, 960.0f, 315.0f);
        this.ageClassComboBox = new JComboBox();
        this.ageClassComboBox.setName("ageClassComboBox");
        FramerFactory.current.installComponent(this.ageClassComboBox, this.contentPanel, 1, 136, 1170.0f, 1290.0f, 1815.0f, 345.0f);
        this.ussaClassLabel = new JLabel();
        this.ussaClassLabel.setName("ussaClassLabel");
        this.ussaClassLabel.setText("USSA Class");
        FramerFactory.current.installComponent(this.ussaClassLabel, this.contentPanel, 1, 136, 3105.0f, 1305.0f, 1170.0f, 315.0f);
        this.ussaClassComboBox = new JComboBox();
        this.ussaClassComboBox.setName("ussaClassComboBox");
        FramerFactory.current.installComponent(this.ussaClassComboBox, this.contentPanel, 1, 136, 4275.0f, 1290.0f, 1815.0f, 345.0f);
    }

    protected void initYearBornItems() {
        this.yearBornLabel = new JLabel();
        this.yearBornLabel.setName("yearBornLabel");
        this.yearBornLabel.setText("Year born");
        FramerFactory.current.installComponent(this.yearBornLabel, this.contentPanel, 1, 136, 0.0f, 1770.0f, 945.0f, 315.0f);
        this.yearBornField = new JTextField();
        this.yearBornField.setName("yearBornField");
        this.yearBornField.setColumns(10);
        FramerFactory.current.installComponent(this.yearBornField, this.contentPanel, 1, 136, 1170.0f, 1770.0f, 1815.0f, 315.0f);
    }

    protected void initAffiliationItems() {
        this.affiliationLabel = new JLabel();
        this.affiliationLabel.setName("affiliationLabel");
        this.affiliationLabel.setText("Affiliation");
        FramerFactory.current.installComponent(this.affiliationLabel, this.contentPanel, 1, 136, 0.0f, 2235.0f, 885.0f, 315.0f);
        this.affiliationComboBox = new JComboBox();
        this.affiliationComboBox.setName("affiliationComboBox");
        FramerFactory.current.installComponent(this.affiliationComboBox, this.contentPanel, 1, 136, 1170.0f, 2220.0f, 2250.0f, 345.0f);
    }

    protected void initUssaNumberItems() {
        this.ussaNumberLabel = new JLabel();
        this.ussaNumberLabel.setName("ussaNumberLabel");
        this.ussaNumberLabel.setText("USSA Number");
        FramerFactory.current.installComponent(this.ussaNumberLabel, this.contentPanel, 1, 136, 0.0f, 2685.0f, 1350.0f, 315.0f);
        this.ussaNumberField = new JTextField();
        this.ussaNumberField.setName("ussaNumberField");
        this.ussaNumberField.setColumns(10);
        FramerFactory.current.installComponent(this.ussaNumberField, this.contentPanel, 1, 136, 1455.0f, 2685.0f, 1935.0f, 315.0f);
    }

    protected void initTeamItems() {
    }

    protected void initOperationButtonsPanel() {
        this.operationButtonsPanel = new OKCancelButtonsPanel();
        this.operationButtonsPanel.setName("operationButtonsPanel");
        FramerFactory.current.installComponent(this.operationButtonsPanel, this.contentPanel, this.operationButtonsPanel.bottomCenterFramingSpec());
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1050.0f, 990.0f, 6570.0f, 4835.0f);
    }

    protected Map<String, Object> constructPropertyValueItemMap() {
        HashMap<String, Object> mappingTable = new HashMap<String, Object>();
        mappingTable.put("lastName", this.lastNameField);
        mappingTable.put("firstName", this.firstNameField);
        mappingTable.put("bibNumber", this.bibNumberField);
        mappingTable.put("ageClass", this.ageClassComboBox);
        mappingTable.put("nationalClass", this.ussaClassComboBox);
        mappingTable.put("birthYear", this.yearBornField);
        mappingTable.put("affiliation", this.affiliationComboBox);
        mappingTable.put("ussaNumber", this.ussaNumberField);
        return mappingTable;
    }

    @Override
    protected void initializeWindow() {
        this.propertyValueItemMap = this.constructPropertyValueItemMap();
        this.dialogWindow.setTitle(this.myApp().getTitle());
        this.lastNameField.setDocument(this.myApp().getLastNameHolder());
        this.firstNameField.setDocument(this.myApp().getFirstNameHolder());
        this.bibNumberField.setDocument(this.myApp().getBibNumberHolder());
        SwingPatches.installComboBoxModel(this.ageClassComboBox, this.myApp().getAgeClassListHolder());
        SwingPatches.installComboBoxModel(this.ussaClassComboBox, this.myApp().getNationalClassListHolder());
        this.yearBornField.setDocument(this.myApp().getBirthYearHolder());
        SwingPatches.installComboBoxModel(this.affiliationComboBox, this.myApp().getAffiliationListHolder());
        this.ussaNumberField.setDocument(this.myApp().getUSSANumberHolder());
        if (this.myApp().mapsAgeClassToNationalClass()) {
            this.ussaClassLabel.setVisible(false);
            this.ussaClassComboBox.setVisible(false);
        }
        this.configureConnections();
    }

    protected EditRacerDataDialog myApp() {
        return (EditRacerDataDialog)this.getAppModel();
    }

    protected void configureConnections() {
        this.nextBibNumberButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditRacerDataDialogWindow.this.myApp().setNextAvailableBibNumber();
            }
        });
        this.operationButtonsPanel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (EditRacerDataDialogWindow.this.acceptChanges()) {
                    EditRacerDataDialogWindow.this.requestCloseWindow();
                }
            }
        });
        this.operationButtonsPanel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditRacerDataDialogWindow.this.requestCloseWindow();
            }
        });
    }

    protected boolean acceptChanges() {
        if (!this.myApp().hasChanges()) {
            return true;
        }
        UserConfirmationValidationResolver validationResolver = this.myToolServices().constructUserConfirmationValidationResolver(this.dialogWindow);
        ValidationResult validationResult = this.myApp().validateChanges(validationResolver);
        if (validationResult.failed()) {
            Component valueItem = (Component)this.propertyValueItemMap.get(validationResult.getAspect());
            if (valueItem != null) {
                if (valueItem instanceof JTextField) {
                    ((JTextField)valueItem).selectAll();
                }
                valueItem.requestFocus();
            }
            if (validationResolver.numberOfDenials == 0) {
                MessageDialog.displayWarning("Invalid Racer Data", validationResult.getMessage(), this.dialogWindow);
            }
            return false;
        }
        try {
            this.myApp().acceptChanges();
        }
        catch (RuntimeException ex) {
            DebugSupport.current().dumpStack(ex);
            MessageDialog.displayError("Error Saving Changes", "Unable to save racer data changes: " + ex.getMessage(), this.dialogWindow);
            return false;
        }
        return true;
    }
}

