/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.ui.NewRacerDialog;
import org.ussamasters.aces.tools.ui.RaceCompetitorsReconciliationViewer;
import org.ussamasters.aces.tools.ui.RaceIdentifierModel;
import org.ussamasters.aces.tools.ui.swing.RSTFrameWindow;
import org.ussamasters.aces.tools.ui.swing.RaceIdentifierPanel;
import org.ussamasters.aces.tools.ui.swing.RacerListEditorPanel;
import org.ussamasters.aces.tools.ui.swing.RacerListPanel;

public class RaceCompetitorsReconciliationViewerWindow
extends RSTFrameWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 13080.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 7245.0f;
    protected RaceIdentifierPanel raceIdentifierPanel;
    protected JPanel reconcilationItemsPanel;
    protected RacerListPanel newRacersListPanel;
    protected JButton addNewRacerButton;
    protected JButton addAllNewRacersButton;
    protected JButton removeNewRacerButton;
    protected JPanel seriesRacersItemsPanel;
    protected RacerListEditorPanel seriesRacerListEditorPanel;
    protected JButton saveChangesButton;

    public RaceCompetitorsReconciliationViewerWindow() {
    }

    public RaceCompetitorsReconciliationViewerWindow(String arg1) {
        super(arg1);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.frameWindow.setTitle("Race Competitors Reconciliation Report");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initReconcilationItemsPanel();
        this.initSeriesRacersItemsPanel();
        this.initSaveChangesButton();
    }

    protected void initReconcilationItemsPanel() {
        this.reconcilationItemsPanel = new JPanel();
        this.reconcilationItemsPanel.setName("reconcilationItemsPanel");
        FramerFactory.current.installComponent(this.reconcilationItemsPanel, this.contentPanel, 1, 186, 0.0f, 0.0f, 0.5f, 600.0f);
        this.reconcilationItemsPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.raceIdentifierPanel = new RaceIdentifierPanel();
        this.raceIdentifierPanel.setBorder(BorderFactory.createTitledBorder("Race Data"));
        FramerFactory.current.installComponent(this.raceIdentifierPanel, this.reconcilationItemsPanel, 1, 168, 0.0f, 0.0f, 0.0f, 2130.0f);
        float DY_BELOW_RID_PANEL = 2230.0f;
        float DY_BUTTON_SPACING = 400.0f;
        this.newRacersListPanel = new RacerListPanel();
        this.newRacersListPanel.setBorder(BorderFactory.createTitledBorder("Unrecognized Race Competitors"));
        FramerFactory.current.installComponent(this.newRacersListPanel, this.reconcilationItemsPanel, 1, 170, 0.0f, 2230.0f, 1110.0f, 0.0f);
        this.addNewRacerButton = new JButton();
        this.addNewRacerButton.setName("addNewRacerButton");
        this.addNewRacerButton.setText("Add >>");
        this.addNewRacerButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.addNewRacerButton, this.reconcilationItemsPanel, 1, 40, 990.0f, 2330.0f, 0.0f, 315.0f);
        this.addAllNewRacersButton = new JButton();
        this.addAllNewRacersButton.setName("addAllNewRacersButton");
        this.addAllNewRacersButton.setText("Add  all>>");
        this.addAllNewRacersButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.addAllNewRacersButton, this.reconcilationItemsPanel, 1, 40, 990.0f, 2730.0f, 0.0f, 315.0f);
        this.removeNewRacerButton = new JButton();
        this.removeNewRacerButton.setName("removeNewRacerButton");
        this.removeNewRacerButton.setText("Delete");
        this.removeNewRacerButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.removeNewRacerButton, this.reconcilationItemsPanel, 1, 40, 990.0f, 3130.0f, 0.0f, 315.0f);
    }

    protected void initSeriesRacersItemsPanel() {
        this.seriesRacersItemsPanel = new JPanel();
        this.seriesRacersItemsPanel.setName("seriesRacersItemsPanel");
        FramerFactory.current.installComponent(this.seriesRacersItemsPanel, this.contentPanel, 1, 106, 0.5f, 0.0f, 0.0f, 600.0f);
        this.seriesRacersItemsPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.seriesRacerListEditorPanel = new RacerListEditorPanel();
        this.seriesRacerListEditorPanel.setName("seriesRacerListEditorPanel");
        this.seriesRacerListEditorPanel.setBorder(BorderFactory.createTitledBorder("Registered Racers"));
        FramerFactory.current.installComponent(this.seriesRacerListEditorPanel, this.seriesRacersItemsPanel, 1, 170, 195.0f, 0.0f, 0.0f, 0.0f);
    }

    protected void initSaveChangesButton() {
        this.saveChangesButton = new JButton();
        this.saveChangesButton.setName("saveChangesButton");
        this.saveChangesButton.setText("Save Changes");
        this.saveChangesButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.saveChangesButton, this.contentPanel, 1, 66, 0.485f, 315.0f, 1455.0f, 0.0f);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 465.0f, 525.0f, 13080.0f, 7245.0f);
    }

    protected RaceCompetitorsReconciliationViewer myApp() {
        return (RaceCompetitorsReconciliationViewer)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.configureAppNameWindowTitle();
        RaceIdentifierModel raceIDModel = new RaceIdentifierModel(this.myApp().getRace(), false);
        this.raceIdentifierPanel.setModel(raceIDModel);
        this.newRacersListPanel.setRacerListHolder(this.myApp().getNewRacersListHolder());
        this.seriesRacerListEditorPanel.setEditor(this.myApp().getRacerListEditor());
        this.configureConnections();
    }

    protected void configureConnections() {
        this.myApp().getNewRacersListHolder().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                RaceCompetitorsReconciliationViewerWindow.this.updateNewRacerOperationEnablements();
            }
        });
        this.addNewRacerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceCompetitorsReconciliationViewerWindow.this.addNewRacer(RaceCompetitorsReconciliationViewerWindow.this.myApp().getSelectedNewRacer());
            }
        });
        this.addAllNewRacersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceCompetitorsReconciliationViewerWindow.this.addAllNewRacers();
            }
        });
        this.removeNewRacerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceCompetitorsReconciliationViewerWindow.this.myApp().removeNewRacer(RaceCompetitorsReconciliationViewerWindow.this.myApp().getSelectedNewRacer());
            }
        });
        this.myApp().getRacerListEditor().getHasChangesHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                RaceCompetitorsReconciliationViewerWindow.this.saveChangesButton.setEnabled(RaceCompetitorsReconciliationViewerWindow.this.myApp().hasUnsavedChanges());
            }
        });
        this.saveChangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceCompetitorsReconciliationViewerWindow.this.saveChanges();
            }
        });
    }

    protected void saveChanges() {
        try {
            this.myApp().saveChanges();
        }
        catch (RuntimeException | RaceDataIOException ex) {
            this.reportSaveChangesFailed(ex);
        }
    }

    protected void reportSaveChangesFailed(Exception ex) {
        DebugSupport.current().dumpStack(ex, 10);
        MessageDialog.displayError("Save Changes Failed", "Unable to save changes: " + ex.getMessage(), this.frameWindow);
    }

    protected void updateNewRacerOperationEnablements() {
        Racer selectedRacer = this.myApp().getSelectedNewRacer();
        boolean hasRacerSelection = selectedRacer != null;
        this.addNewRacerButton.setEnabled(hasRacerSelection);
        this.removeNewRacerButton.setEnabled(hasRacerSelection);
        this.addAllNewRacersButton.setEnabled(this.myApp().getNewRacersListHolder().size() > 0);
    }

    protected void addNewRacer(Racer newRacer) {
        ToolSessionRacerList currentSeriesRacers = this.myApp().getRacerListEditor().getRacerList();
        if (NewRacerDialog.validateNewRacer(newRacer, currentSeriesRacers).succeeded()) {
            this.myApp().addNewRacer(newRacer);
        } else {
            Racer adjustedNewRacer = NewRacerDialog.openOn(newRacer, currentSeriesRacers, this.getMainWindow());
            if (adjustedNewRacer == null) {
                return;
            }
            this.myApp().addNewRacer(newRacer, adjustedNewRacer);
        }
        this.seriesRacerListEditorPanel.ensureSelectionIsVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAllNewRacers() {
        ToolSessionRacerList currentSeriesRacers = this.myApp().getRacerListEditor().getRacerList();
        Cursor originalCursor = this.frameWindow.getCursor();
        this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ArrayList<Racer> racersToAdd = new ArrayList<Racer>();
            int nSkipped = 0;
            for (Racer newRacer : this.myApp().getNewRacersListHolder().getRacerList().getRacers()) {
                if (NewRacerDialog.validateNewRacer(newRacer, currentSeriesRacers).succeeded()) {
                    racersToAdd.add(newRacer);
                    continue;
                }
                ++nSkipped;
            }
            for (Racer newRacer : racersToAdd) {
                this.myApp().addNewRacer(newRacer);
            }
        }
        finally {
            this.frameWindow.setCursor(originalCursor);
        }
    }
}

