/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.mv.swing.TableHolder;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ussamasters.aces.racedata.io.RaceDataNormalizationServices;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.tools.foundation.processors.RacerNameChecker;
import org.ussamasters.aces.tools.ui.ChooseRacerDialog;
import org.ussamasters.aces.tools.ui.NewRacerDialog;
import org.ussamasters.aces.tools.ui.RaceResultReconcilationModel;
import org.ussamasters.aces.tools.ui.RacerListEditorModel;
import org.ussamasters.aces.tools.ui.swing.RSTPanel;
import org.ussamasters.aces.tools.ui.swing.RacerListEditorPanel;

public class RaceResultReconciliationPanel
extends RSTPanel {
    protected JTabbedPane validationResultsTabbedPane;
    protected JPanel unregisteredRacersTabbedPanePage;
    protected JScrollPane unregisteredRacersTableScrollPane;
    protected JTable unregisteredRacersTable;
    protected JButton addUnregisteredRacerButton;
    protected JButton associateUnregisteredRacerButton;
    protected JLabel unregisteredRacersSummaryField;
    protected JPanel inconsistentBibRacersTabbedPanePage;
    protected JScrollPane inconsistentBibRacersTableScrollPane;
    protected JTable inconsistentBibRacersTable;
    protected JButton acceptInconsistentBibResolutionButton;
    protected JButton acceptAllInconsistentBibResolutionButton;
    protected JButton associateInconsistentBibRacerButton;
    protected JLabel inconsistentBibRacersSummaryField;
    protected JPanel maybeProblemRacersTabbedPanePage;
    protected JScrollPane mayProblemRacersTableScrollPane;
    protected JTable maybeProblemRacersTable;
    protected JButton acceptMaybeProblemNameResolutionButton;
    protected JButton acceptAllMaybeProblemNameResolutionButton;
    protected JButton editResultNameButton;
    protected JButton associateProblemRacerButton;
    protected JLabel maybeProblemRacersSummaryField;
    protected RaceResultReconcilationModel reconciliationModel;
    protected RacerListEditorModel racerListEditor;
    protected RacerListEditorPanel racerListPanel;

    public RaceResultReconciliationPanel() {
        this.init();
    }

    protected void init() {
        this.initSelf();
        this.initChildComponents();
    }

    protected void initSelf() {
        this.setName("raceResultReconciliationPanel");
        this.setLayout(FramerFactory.current.newLayoutManager());
    }

    public void initChildComponents() {
        this.initValidationResultsTabbedPane();
    }

    public void initValidationResultsTabbedPane() {
        this.validationResultsTabbedPane = new JTabbedPane();
        this.validationResultsTabbedPane.setName("validationResultsTabbedPane");
        FramerFactory.current.installComponent(this.validationResultsTabbedPane, this, 1, 170, 0.0f, 0.0f, 0.0f, 0.0f);
        this.initInconsistentBibRacersTabbedPanePage();
        this.initMaybeProblemRacersTabbedPanePage();
        this.initUnregisteredRacersTabbedPanePage();
        this.validationResultsTabbedPane.setSelectedIndex(0);
    }

    protected void installValidationTabPage(JPanel tabPanePage, String label) {
        tabPanePage.setBounds(4, 25, 613, 264);
        this.validationResultsTabbedPane.addTab(label, tabPanePage);
    }

    public void initUnregisteredRacersTabbedPanePage() {
        this.unregisteredRacersTabbedPanePage = new JPanel();
        this.unregisteredRacersTabbedPanePage.setName("unregisteredRacersTabbedPanePage");
        this.installValidationTabPage(this.unregisteredRacersTabbedPanePage, "Unrecognized Racers");
        this.unregisteredRacersTabbedPanePage.setLayout(FramerFactory.current.newLayoutManager());
        this.unregisteredRacersTableScrollPane = new JScrollPane();
        this.unregisteredRacersTableScrollPane.setName("unregisteredRacersTableScrollPane");
        FramerFactory.current.installComponent(this.unregisteredRacersTableScrollPane, this.unregisteredRacersTabbedPanePage, 1, 170, 0.0f, 0.0f, 1635.0f, 345.0f);
        this.unregisteredRacersTable = new JTable();
        this.unregisteredRacersTable.setName("unregisteredRacersTable");
        this.unregisteredRacersTableScrollPane.setViewportView(this.unregisteredRacersTable);
        this.unregisteredRacersTable.setToolTipText("Unknown racers - maybe new or Associate to identify correct competitor if in series racer list");
        this.addUnregisteredRacerButton = new JButton();
        this.addUnregisteredRacerButton.setName("addUnregisteredRacerButton");
        this.addUnregisteredRacerButton.setText("Add...");
        this.addUnregisteredRacerButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.addUnregisteredRacerButton, this.unregisteredRacersTabbedPanePage, 1, 40, 1125.0f, 0.0f, 0.0f, 315.0f);
        this.associateUnregisteredRacerButton = new JButton();
        this.associateUnregisteredRacerButton.setName("associateUnregisteredRacerButton");
        this.associateUnregisteredRacerButton.setText("Associate...");
        this.associateUnregisteredRacerButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.associateUnregisteredRacerButton, this.unregisteredRacersTabbedPanePage, 1, 40, 1125.0f, 405.0f, 0.0f, 315.0f);
        this.unregisteredRacersSummaryField = new JLabel();
        this.unregisteredRacersSummaryField.setName("unregisteredRacersSummaryField");
        this.unregisteredRacersSummaryField.setText("<unregistered racers summary>");
        FramerFactory.current.installComponent(this.unregisteredRacersSummaryField, this.unregisteredRacersTabbedPanePage, 1, 162, 60.0f, 315.0f, 0.0f, 0.0f);
    }

    public void initInconsistentBibRacersTabbedPanePage() {
        this.inconsistentBibRacersTabbedPanePage = new JPanel();
        this.inconsistentBibRacersTabbedPanePage.setName("inconsistentBibRacersTabbedPanePage");
        this.installValidationTabPage(this.inconsistentBibRacersTabbedPanePage, "Inconsistent Bibs");
        this.inconsistentBibRacersTabbedPanePage.setLayout(FramerFactory.current.newLayoutManager());
        this.inconsistentBibRacersTableScrollPane = new JScrollPane();
        this.inconsistentBibRacersTableScrollPane.setName("inconsistentBibRacersTableScrollPane");
        FramerFactory.current.installComponent(this.inconsistentBibRacersTableScrollPane, this.inconsistentBibRacersTabbedPanePage, 1, 170, 0.0f, 0.0f, 1590.0f, 345.0f);
        this.inconsistentBibRacersTable = new JTable();
        this.inconsistentBibRacersTable.setName("inconsistentBibRacersTable");
        this.inconsistentBibRacersTableScrollPane.setViewportView(this.inconsistentBibRacersTable);
        this.inconsistentBibRacersTable.setToolTipText("Racers whose name and age class match but race bib is different than in series racer list.");
        this.acceptInconsistentBibResolutionButton = new JButton();
        this.acceptInconsistentBibResolutionButton.setName("acceptInconsistentBibResolutionButton");
        this.acceptInconsistentBibResolutionButton.setText("Accept bib");
        this.acceptInconsistentBibResolutionButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.acceptInconsistentBibResolutionButton, this.inconsistentBibRacersTabbedPanePage, 1, 40, 1185.0f, 0.0f, 0.0f, 315.0f);
        this.acceptAllInconsistentBibResolutionButton = new JButton();
        this.acceptAllInconsistentBibResolutionButton.setName("acceptAllInconsistentBibResolutionButton");
        this.acceptAllInconsistentBibResolutionButton.setText("Accept all");
        this.acceptAllInconsistentBibResolutionButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.acceptAllInconsistentBibResolutionButton, this.inconsistentBibRacersTabbedPanePage, 1, 40, 1185.0f, 420.0f, 0.0f, 315.0f);
        this.associateInconsistentBibRacerButton = new JButton();
        this.associateInconsistentBibRacerButton.setName("associateInconsistentBibRacerButton");
        this.associateInconsistentBibRacerButton.setText("Associate...");
        this.associateInconsistentBibRacerButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.associateInconsistentBibRacerButton, this.inconsistentBibRacersTabbedPanePage, 1, 40, 1125.0f, 840.0f, 0.0f, 315.0f);
        this.inconsistentBibRacersSummaryField = new JLabel();
        this.inconsistentBibRacersSummaryField.setName("inconsistentBibRacersSummaryField");
        this.inconsistentBibRacersSummaryField.setText("<inconsistent bibs summary>");
        FramerFactory.current.installComponent(this.inconsistentBibRacersSummaryField, this.inconsistentBibRacersTabbedPanePage, 1, 162, 0.0f, 315.0f, 0.0f, 0.0f);
    }

    public void initMaybeProblemRacersTabbedPanePage() {
        this.maybeProblemRacersTabbedPanePage = new JPanel();
        this.maybeProblemRacersTabbedPanePage.setName("maybeProblemRacersTabbedPanePage");
        this.installValidationTabPage(this.maybeProblemRacersTabbedPanePage, "Inconsistent Names");
        this.maybeProblemRacersTabbedPanePage.setLayout(FramerFactory.current.newLayoutManager());
        this.mayProblemRacersTableScrollPane = new JScrollPane();
        this.mayProblemRacersTableScrollPane.setName("mayProblemRacersTableScrollPane");
        FramerFactory.current.installComponent(this.mayProblemRacersTableScrollPane, this.maybeProblemRacersTabbedPanePage, 1, 170, 0.0f, 0.0f, 1590.0f, 345.0f);
        this.maybeProblemRacersTable = new JTable();
        this.maybeProblemRacersTable.setName("maybeProblemRacersTable");
        this.mayProblemRacersTableScrollPane.setViewportView(this.maybeProblemRacersTable);
        this.maybeProblemRacersTable.setToolTipText("Racers who appear to match on bib and age class but name is slightly different than in series racer list (maybe typo or minor difference).");
        this.acceptMaybeProblemNameResolutionButton = new JButton();
        this.acceptMaybeProblemNameResolutionButton.setText("Accept name");
        this.acceptMaybeProblemNameResolutionButton.setName("acceptMaybeProblemNameResolutionButton");
        this.acceptMaybeProblemNameResolutionButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.acceptMaybeProblemNameResolutionButton, this.maybeProblemRacersTabbedPanePage, 1, 40, 1245.0f, 15.0f, 0.0f, 315.0f);
        this.acceptAllMaybeProblemNameResolutionButton = new JButton();
        this.acceptAllMaybeProblemNameResolutionButton.setName("acceptAllMaybeProblemNameResolutionButton");
        this.acceptAllMaybeProblemNameResolutionButton.setText("Accept all");
        this.acceptAllMaybeProblemNameResolutionButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.acceptAllMaybeProblemNameResolutionButton, this.maybeProblemRacersTabbedPanePage, 1, 40, 1245.0f, 420.0f, 0.0f, 315.0f);
        this.editResultNameButton = new JButton();
        this.editResultNameButton.setName("editResultNameButton");
        this.editResultNameButton.setText("Edit Name...");
        this.editResultNameButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.editResultNameButton, this.maybeProblemRacersTabbedPanePage, 1, 40, 1245.0f, 825.0f, 0.0f, 315.0f);
        this.associateProblemRacerButton = new JButton();
        this.associateProblemRacerButton.setName("associateProblemRacerButton");
        this.associateProblemRacerButton.setText("Associate...");
        this.associateProblemRacerButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.associateProblemRacerButton, this.maybeProblemRacersTabbedPanePage, 1, 40, 1245.0f, 1230.0f, 0.0f, 315.0f);
        this.maybeProblemRacersSummaryField = new JLabel();
        this.maybeProblemRacersSummaryField.setName("maybeProblemRacersSummaryField");
        this.maybeProblemRacersSummaryField.setText("<inconsistent names summary>");
        FramerFactory.current.installComponent(this.maybeProblemRacersSummaryField, this.maybeProblemRacersTabbedPanePage, 1, 162, 0.0f, 315.0f, 0.0f, 0.0f);
    }

    protected RaceResultReconcilationModel myModel() {
        return this.reconciliationModel;
    }

    public void setModel(RaceResultReconcilationModel reconciliationModel) {
        this.reconciliationModel = reconciliationModel;
        this.initializeWindow();
    }

    public void setEditor(RacerListEditorModel racerListEditor) {
        this.racerListEditor = racerListEditor;
    }

    public void setRacerListPanel(RacerListEditorPanel racerListPanel) {
        this.racerListPanel = racerListPanel;
    }

    protected void initializeWindow() {
        String associateButtonToolTip = "Choose the series racer to whom the selected result belongs.";
        this.addUnregisteredRacerButton.setToolTipText("Add the racer for the selected result to the series racer list.");
        this.associateUnregisteredRacerButton.setToolTipText(associateButtonToolTip);
        this.acceptInconsistentBibResolutionButton.setToolTipText("Accept the bib number of the registered racer for the selected result.");
        this.acceptAllInconsistentBibResolutionButton.setToolTipText("Accept the bib numbers of the registered racers for all selected results.");
        this.associateInconsistentBibRacerButton.setToolTipText(associateButtonToolTip);
        this.acceptMaybeProblemNameResolutionButton.setToolTipText("Accept the name of the registered racer for the selected result.");
        this.acceptAllMaybeProblemNameResolutionButton.setToolTipText("Accept the names of the registered racers for all selected results.");
        this.editResultNameButton.setToolTipText("Edit the name of the racer in the selected result.");
        this.associateProblemRacerButton.setToolTipText(associateButtonToolTip);
        int nProblems = this.myModel().getUnregisteredRacersTableHolder().size();
        this.unregisteredRacersTable.setModel(this.myModel().getUnregisteredRacersTableHolder().getDataModel());
        this.unregisteredRacersTable.setSelectionModel(this.myModel().getUnregisteredRacersTableHolder().getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.unregisteredRacersTable);
        this.unregisteredRacersSummaryField.setText(nProblems + " unregistered racers (add if really new, associate if already in series list)");
        if (nProblems == 0) {
            this.validationResultsTabbedPane.remove(this.unregisteredRacersTabbedPanePage);
        }
        nProblems = this.myModel().getInconsistentBibRacersTableHolder().size();
        this.inconsistentBibRacersTable.setModel(this.myModel().getInconsistentBibRacersTableHolder().getDataModel());
        this.inconsistentBibRacersTable.setSelectionModel(this.myModel().getInconsistentBibRacersTableHolder().getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.inconsistentBibRacersTable);
        this.inconsistentBibRacersSummaryField.setText(nProblems + " competitors with inconsistent bib number (name and class match)");
        if (nProblems == 0) {
            this.validationResultsTabbedPane.remove(this.inconsistentBibRacersTabbedPanePage);
        }
        nProblems = this.myModel().getMaybeProblemRacersTableHolder().size();
        this.maybeProblemRacersTable.setModel(this.myModel().getMaybeProblemRacersTableHolder().getDataModel());
        this.maybeProblemRacersTable.setSelectionModel(this.myModel().getMaybeProblemRacersTableHolder().getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.maybeProblemRacersTable);
        this.maybeProblemRacersSummaryField.setText(nProblems + " racer names should be reviewed (bib and class match)");
        if (nProblems == 0) {
            this.validationResultsTabbedPane.remove(this.maybeProblemRacersTabbedPanePage);
        }
        this.updateUnregisteredRacersOperations();
        this.updateInconsistentBibRacersOperations();
        this.updateMaybeProblemsRacersOperations();
        this.configureConnections();
    }

    protected void configureConnections() {
        this.unregisteredRacersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                RaceResultReconciliationPanel.this.updateUnregisteredRacersOperations();
            }
        });
        this.addUnregisteredRacerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationPanel.this.addUnregisteredRacer(RaceResultReconciliationPanel.this.myModel().getSelectedUnregisteredRacer());
            }
        });
        this.associateUnregisteredRacerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationPanel.this.resolveRacer(RaceResultReconciliationPanel.this.myModel().getSelectedUnregisteredRacer(), RaceResultReconciliationPanel.this.myModel().getUnregisteredRacersTableHolder());
            }
        });
        this.inconsistentBibRacersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                RaceResultReconciliationPanel.this.updateInconsistentBibRacersOperations();
            }
        });
        this.acceptInconsistentBibResolutionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationPanel.this.acceptInconsistentBibResolution(RaceResultReconciliationPanel.this.myModel().getSelectedInconsistentBibRacer());
            }
        });
        this.acceptAllInconsistentBibResolutionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationPanel.this.acceptInconsistentBibResolution(RaceResultReconciliationPanel.this.myModel().getSelectedInconsistentBibRacers());
            }
        });
        this.associateInconsistentBibRacerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationPanel.this.resolveRacer(RaceResultReconciliationPanel.this.myModel().getSelectedInconsistentBibRacer(), RaceResultReconciliationPanel.this.myModel().getInconsistentBibRacersTableHolder());
            }
        });
        this.maybeProblemRacersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                RaceResultReconciliationPanel.this.updateMaybeProblemsRacersOperations();
            }
        });
        this.acceptMaybeProblemNameResolutionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationPanel.this.acceptMaybeProblemNameResolution(RaceResultReconciliationPanel.this.myModel().getSelectedMaybeProblemRacer());
            }
        });
        this.acceptAllMaybeProblemNameResolutionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationPanel.this.acceptMaybeProblemNameResolution(RaceResultReconciliationPanel.this.myModel().getSelectedMaybeProblemRacers());
            }
        });
        this.editResultNameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationPanel.this.editResultName(RaceResultReconciliationPanel.this.myModel().getSelectedMaybeProblemRacer());
            }
        });
        this.associateProblemRacerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationPanel.this.resolveRacer(RaceResultReconciliationPanel.this.myModel().getSelectedMaybeProblemRacer(), RaceResultReconciliationPanel.this.myModel().getMaybeProblemRacersTableHolder());
            }
        });
    }

    protected void addUnregisteredRacer(RaceEntryResult aRacerResult) {
        Gender gender = aRacerResult.getGender();
        RaceClass<?> raceClass = aRacerResult.getRaceClass();
        RaceClass<?> ageClass = raceClass;
        if (ageClass.isAbilityGroupClass()) {
            ageClass = RaceClass.getUnknownClass(this.racerListEditor.getRacerList().getAgeClassClass(), gender);
        }
        String lastName = aRacerResult.getLastName();
        String firstName = aRacerResult.getFirstName();
        if (RaceDataNormalizationServices.needsCasingCorrection(lastName)) {
            lastName = RaceDataNormalizationServices.normalizeNameCasing(lastName);
        }
        if (RaceDataNormalizationServices.needsCasingCorrection(firstName)) {
            firstName = RaceDataNormalizationServices.normalizeNameCasing(firstName);
        }
        Racer newRacer = new Racer(aRacerResult.getBibNumber(), lastName, firstName);
        newRacer.initCompetitionClassValuesLenient(gender, ageClass, null, -1);
        newRacer.initLicenseValues(null, null);
        newRacer = NewRacerDialog.openOn(newRacer, this.racerListEditor.getRacerList(), this.getMainWindow());
        if (newRacer == null) {
            return;
        }
        this.racerListEditor.addRacer(newRacer);
        this.racerListPanel.ensureSelectionIsVisible();
        RaceClass<?> newAgeClass = raceClass.isAbilityGroupClass() || newRacer.getAgeClass() == raceClass ? null : newRacer.getAgeClass();
        this.myModel().updateRacerResult(aRacerResult, this.myModel().getUnregisteredRacersTableHolder(), newRacer.getBibNumber(), newRacer.getLastName(), newRacer.getFirstName(), newAgeClass);
    }

    protected void acceptInconsistentBibResolution(RaceEntryResult aRacerResult) {
        this.myModel().updateInconsistentBibRacerBib(aRacerResult);
    }

    protected void acceptInconsistentBibResolution(List<RaceEntryResult> selectedResults) {
        int nResults = selectedResults.size();
        String message = "You are about to accept the bib resolution for " + nResults + " racer results.\n\nProceed?";
        if (!MessageDialog.confirm(message, this.getMainWindow())) {
            return;
        }
        for (RaceEntryResult racerResult : selectedResults) {
            this.acceptInconsistentBibResolution(racerResult);
        }
    }

    protected void acceptMaybeProblemNameResolution(RaceEntryResult aRacerResult) {
        this.myModel().updateMaybeProblemRacerName(aRacerResult);
    }

    protected void acceptMaybeProblemNameResolution(List<RaceEntryResult> selectedResults) {
        int nResults = selectedResults.size();
        String message = "You are about to accept the name resolution for " + nResults + " racer results.\n\nProceed?";
        if (!MessageDialog.confirm(message, this.getMainWindow())) {
            return;
        }
        for (RaceEntryResult racerResult : selectedResults) {
            this.acceptMaybeProblemNameResolution(racerResult);
        }
    }

    protected void editResultName(RaceEntryResult aRacerResult) {
        String[] editedName = this.myToolServices().editRacerResultName(aRacerResult, this.getMainWindow());
        if (editedName == null) {
            return;
        }
        this.myModel().updateProblemRacerName(aRacerResult, editedName[0], editedName[1]);
    }

    protected void resolveRacer(RaceEntryResult aRacerResult, TableHolder holder) {
        String confirmationMsg;
        boolean isClassSame;
        Racer registeredRacer = this.myModel().getRegisteredRacerCandidateMatch(aRacerResult);
        Racer racer = registeredRacer = registeredRacer != null ? ChooseRacerDialog.openOn(registeredRacer, this.racerListEditor.getRacerList(), this.getMainWindow()) : ChooseRacerDialog.openFor(this.getMainWindow(), this.racerListEditor.getRacerList(), 1);
        if (registeredRacer == null) {
            return;
        }
        int raceBibNumber = aRacerResult.getBibNumber();
        String raceName = aRacerResult.getName();
        RaceClass<?> raceClass = aRacerResult.getRaceClass();
        int registeredBibNumber = registeredRacer.getBibNumber();
        String registeredName = registeredRacer.getName();
        RaceClass<?> registeredClass = raceClass.isNationalClass() ? registeredRacer.getNationalClass() : registeredRacer.getAgeClass();
        boolean isBibSame = raceBibNumber == registeredBibNumber;
        boolean isNameSame = raceName.equals(registeredName);
        boolean bl = isClassSame = raceClass == registeredClass || raceClass.isAbilityGroupClass();
        if (isBibSame && isNameSame && isClassSame) {
            MessageDialog.displayMessage("Nothing To Do", String.format("Racer %s  is already registered in class %s  with bib number %.", aRacerResult.getName(), registeredClass.name, registeredBibNumber), this.getMainWindow());
            return;
        }
        if (!isNameSame) {
            String confirmationMsg2;
            String entryLastName = aRacerResult.getLastName();
            String entryFirstName = aRacerResult.getFirstName();
            if (!RacerNameChecker.getCurrent().sameName(registeredRacer, entryLastName, entryFirstName) && !MessageDialog.confirm(confirmationMsg2 = String.format("You are about to associate the result for %s in %s with the series standings of %s  (bib %s, age class %s).\n\nAre you sure this is what you meant?", raceName, raceClass.name, registeredName, registeredBibNumber, registeredClass.name), this.getMainWindow())) {
                return;
            }
        }
        if (!(isBibSame || this.myModel().getRacerListManagementPolicy().isRaceTempBibNumber(raceBibNumber) || MessageDialog.confirm(confirmationMsg = String.format("You are about to change the bib number of %s from %s to %s (for %s).\n\nIs this correct?", raceName, raceBibNumber, registeredBibNumber, registeredName), this.getMainWindow()))) {
            return;
        }
        if (!isClassSame) {
            if (registeredClass == null) {
                MessageDialog.displayError("Unknown Age Class", String.format("You cannot associate the result for %s in class %s with racer %s.\n\nYou must use the racer list editor to specify an age class.", raceName, raceClass.name, registeredName), this.getMainWindow());
                return;
            }
            confirmationMsg = String.format("***IMPORTANT: You are about to reassign %s from class %s to %s.\n\nAre you sure this class correction should be made??", raceName, raceClass.name, registeredClass.name);
            if (!MessageDialog.confirm(confirmationMsg, this.getMainWindow())) {
                return;
            }
            MessageDialog.displayWarning("Racer Class Change", String.format("You are moving %s from class %s to %s.", registeredName, raceClass.name, registeredClass.name), this.getMainWindow());
        }
        this.myModel().updateRacerResult(aRacerResult, holder, isBibSame ? -1 : registeredBibNumber, isNameSame ? null : registeredRacer.getLastName(), isNameSame ? null : registeredRacer.getFirstName(), isClassSame ? null : registeredClass);
    }

    protected void updateInconsistentBibRacersOperations() {
        int nValuesSelected = this.myModel().getInconsistentBibRacersTableHolder().getSelectionSize();
        boolean hasSingleSelection = nValuesSelected == 1;
        this.acceptInconsistentBibResolutionButton.setEnabled(hasSingleSelection);
        this.acceptAllInconsistentBibResolutionButton.setEnabled(nValuesSelected > 1);
        this.associateInconsistentBibRacerButton.setEnabled(hasSingleSelection);
    }

    protected void updateUnregisteredRacersOperations() {
        int nValuesSelected = this.myModel().getUnregisteredRacersTableHolder().getSelectionSize();
        boolean hasSingleSelection = nValuesSelected == 1;
        boolean allowAddNewRacer = this.myModel().getRaceClassClass().equals(this.racerListEditor.getRacerList().getAgeClassClass());
        this.addUnregisteredRacerButton.setEnabled(allowAddNewRacer && hasSingleSelection);
        this.associateUnregisteredRacerButton.setEnabled(hasSingleSelection);
    }

    protected void updateMaybeProblemsRacersOperations() {
        int nValuesSelected = this.myModel().getMaybeProblemRacersTableHolder().getSelectionSize();
        boolean hasSingleSelection = nValuesSelected == 1;
        this.acceptMaybeProblemNameResolutionButton.setEnabled(hasSingleSelection);
        this.acceptAllMaybeProblemNameResolutionButton.setEnabled(nValuesSelected > 1);
        this.editResultNameButton.setEnabled(hasSingleSelection);
        this.associateProblemRacerButton.setEnabled(hasSingleSelection);
    }
}

