/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.execution.OneArgumentBlock;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.RaceResultsImportTool;
import org.ussamasters.aces.tools.ui.swing.RSTFrameWindow;
import org.ussamasters.aces.tools.ui.swing.RaceSpecificationPanel;
import org.ussamasters.aces.tools.ui.swing.TimingDataImportPanel;

public class RaceResultsImportToolWindow
extends RSTFrameWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 11490.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 9975.0f;
    protected RaceSpecificationPanel raceSpecificationPanel;
    protected TimingDataImportPanel timingDataImportPanel;
    protected JCheckBox generateReportsCheckBox;
    protected JButton importDataButton;

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.frameWindow.setTitle("Race Results Import Tool");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initRaceSpecificationPanel();
        this.initTimingDataImportPanel();
        this.initGenerateReportsCheckBox();
        this.initImportDataButton();
    }

    protected void initRaceSpecificationPanel() {
        this.raceSpecificationPanel = new RaceSpecificationPanel();
        FramerFactory.current.installComponent(this.raceSpecificationPanel, this.contentPanel, 1, 168, 0.0f, 0.0f, 0.0f, 2900.0f);
        this.raceSpecificationPanel.setMinimumSize(new Dimension(1040, 964));
        this.raceSpecificationPanel.setPreferredSize(new Dimension(1040, 964));
    }

    protected void initTimingDataImportPanel() {
        this.timingDataImportPanel = new TimingDataImportPanel();
        this.timingDataImportPanel.setName("timingDataImportPanel");
        FramerFactory.current.installComponent(this.timingDataImportPanel, this.contentPanel, 1, 170, 0.0f, 3000.0f, 0.0f, 450.0f);
    }

    protected void initGenerateReportsCheckBox() {
        this.generateReportsCheckBox = new JCheckBox();
        this.generateReportsCheckBox.setName("generateReportsCheckBox");
        this.generateReportsCheckBox.setText("Generate reports");
        this.generateReportsCheckBox.setSelected(true);
        FramerFactory.current.installComponent(this.generateReportsCheckBox, this.contentPanel, 1, 130, 0.0f, 315.0f, 1935.0f, 0.0f);
    }

    protected void initImportDataButton() {
        this.importDataButton = new JButton();
        this.importDataButton.setName("importDataButton");
        this.importDataButton.setText("Import...");
        this.importDataButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.importDataButton, this.contentPanel, 1, 66, 0.5f, 315.0f, 825.0f, 0.0f);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1005.0f, 210.0f, 11490.0f, 9975.0f);
    }

    protected RaceResultsImportTool myApp() {
        return (RaceResultsImportTool)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.configureAppNameWindowTitle();
        this.raceSpecificationPanel.setModel(this.myApp().getRaceSpecificationModel());
        this.timingDataImportPanel.setModel(this.myApp().getTimingDataImportModel());
        if (!this.myApp().getEnableReportGeneration()) {
            this.generateReportsCheckBox.setSelected(false);
            this.generateReportsCheckBox.setEnabled(false);
            this.generateReportsCheckBox.setVisible(false);
        }
        this.importDataButton.setEnabled(false);
        this.configureConnections();
    }

    protected void configureConnections() {
        this.raceSpecificationPanel.addRaceClassChangedListener(new OneArgumentBlock(this, "UpdateImportSpecificationForRaceClassAction"){

            @Override
            protected Object evaluateExpression(Object anArg) {
                RaceResultsImportToolWindow.this.myApp().getTimingDataImportModel().setRaceClassClass((Class)anArg);
                return null;
            }
        });
        this.myApp().getTimingDataImportModel().getHasTimingDataHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                RaceResultsImportToolWindow.this.importDataButton.setEnabled(RaceResultsImportToolWindow.this.myApp().getTimingDataImportModel().getHasTimingDataHolder().getValue());
            }
        });
        this.importDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (RaceResultsImportToolWindow.this.importRaceResults()) {
                    RaceResultsImportToolWindow.this.requestCloseWindow();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean importRaceResults() {
        ValidationResult validationResult = this.validateImportRequest();
        if (!validationResult.succeeded()) {
            MessageDialog.displayWarning("Import Results Data Problem", validationResult.getMessage(), this.frameWindow);
            return false;
        }
        boolean generateReports = this.generateReportsCheckBox.isSelected();
        boolean displayReports = true;
        Cursor originalCursor = this.frameWindow.getCursor();
        try {
            this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.myApp().importRaceResultsData(generateReports, displayReports);
        }
        catch (IOException ex) {
            this.reportImportFailure(ex);
            boolean bl = false;
            return bl;
        }
        catch (RaceDataIOException ex) {
            this.reportImportFailure(ex);
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException ex) {
            this.reportImportFailure(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.frameWindow.setCursor(originalCursor);
        }
        return true;
    }

    protected void reportImportFailure(Exception ex) {
        String errorMessage;
        if (ex instanceof RaceDataIOException) {
            this.timingDataImportPanel.selectLineContainingError((RaceDataIOException)ex);
        }
        if ((errorMessage = ex.getLocalizedMessage()) == null) {
            errorMessage = "" + ex;
        }
        DebugSupport.current().dump("****ERROR: " + errorMessage);
        DebugSupport.current().dumpStack(ex, 10);
        MessageDialog.displayError("Import Failed", errorMessage, this.frameWindow);
    }

    protected ValidationResult validateImportRequest() {
        ValidationResult validationResult = this.timingDataImportPanel.validateSpecifications();
        if (validationResult.failed()) {
            return validationResult;
        }
        return this.myApp().validateImportRequest();
    }

    public static void main(String[] args) {
        RaceResultsImportTool.initiateSession();
        RaceResultsImportTool appModel = new RaceResultsImportTool();
        appModel.openWindow(new RaceResultsImportToolWindow());
    }
}

