/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.io.FileSystemServices;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.OperationAction;
import com.glaivestone.javax.swing.SwingServices;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.mv.swing.ConfigurableListCellRenderer;
import com.glaivestone.mv.swing.ValueRenderer;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;
import org.ussamasters.aces.tools.ui.SeriesScoringTool;
import org.ussamasters.aces.tools.ui.swing.ParameterSpecificationsPanel;
import org.ussamasters.aces.tools.ui.swing.RSTFrameWindow;
import org.ussamasters.aces.tools.ui.swing.RaceSeriesDescriptionPanel;
import org.ussamasters.aces.tools.ui.swing.ReportFormatOptionsPanel;
import org.ussamasters.aces.tools.ui.swing.ReportViewOperationsPanel;
import org.ussamasters.aces.tools.ui.swing.ScoredRaceSeriesPanel;

public abstract class SeriesScoringToolWindow
extends RSTFrameWindow {
    public static final ValueRenderer SCORING_POLICY_RENDERER = new ValueRenderer(){

        @Override
        public String toDisplayString(Object aValue) {
            return ((ScoringPolicySpecification)aValue).label;
        }
    };
    protected RaceSeriesDescriptionPanel raceSeriesDescriptionPanel;
    protected ScoredRaceSeriesPanel scoredRaceSeriesPanel;
    protected JComboBox<ScoringPolicySpecification> scoringPoliciesComboBox;
    protected JTextArea scoringPolicyDescription;
    protected ParameterSpecificationsPanel scoringPolicyParmsPanel;
    protected JButton computeResultsButton;
    protected ReportFormatOptionsPanel reportFormatOptionsPanel;
    protected ReportViewOperationsPanel viewReportOperationsPanel;
    protected OperationAction openCorrectionsLogAction;
    protected OperationAction generateReportsAction;
    protected OperationAction viewHTMLReportsAction;
    protected OperationAction viewTextReportsAction;
    protected OperationAction viewPdfReportsAction;
    protected OperationAction viewReportsAction;
    protected OperationAction deleteReportsAction;
    protected JFileChooser reportFilesChooser;

    protected SeriesScoringToolWindow() {
    }

    protected SeriesScoringToolWindow(String title) {
        super(title);
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    public void initRaceSeriesDescriptionPanel(float rightInset) {
        this.raceSeriesDescriptionPanel = new RaceSeriesDescriptionPanel();
        FramerFactory.current.installComponent(this.raceSeriesDescriptionPanel, this.contentPanel, 1, 168, 0.0f, 0.0f, rightInset, 810.0f);
    }

    protected void initScoredRaceSeriesPanel(float insetFromTop) {
        this.scoredRaceSeriesPanel = new ScoredRaceSeriesPanel();
        FramerFactory.current.installComponent(this.scoredRaceSeriesPanel, this.contentPanel, 1, 170, 0.0f, insetFromTop, 0.0f, 3300.0f);
    }

    protected void initScoringOperationsPanel(float scoringFormulaWidth) {
        float itemTopOffset = 0.0f;
        JPanel scoringSectionPanel = new JPanel();
        scoringSectionPanel.setBorder(BorderFactory.createTitledBorder("Scoring Operations"));
        FramerFactory.current.installComponent(scoringSectionPanel, this.contentPanel, 1, 162, 0.0f, 3200.0f, 0.0f, 0.0f);
        scoringSectionPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.scoringPoliciesComboBox = new JComboBox();
        this.scoringPoliciesComboBox.setRenderer(new ConfigurableListCellRenderer(SCORING_POLICY_RENDERER));
        FramerFactory.current.installComponent(this.scoringPoliciesComboBox, scoringSectionPanel, 1, 136, 0.0f, itemTopOffset, scoringFormulaWidth, 345.0f);
        this.scoringPolicyDescription = new JTextArea();
        this.scoringPolicyDescription.setLineWrap(true);
        this.scoringPolicyDescription.setWrapStyleWord(true);
        SwingServices.current.applyLabelLookAndFeel(this.scoringPolicyDescription);
        FramerFactory.current.installComponent(this.scoringPolicyDescription, scoringSectionPanel, 1, 168, scoringFormulaWidth + 250.0f, itemTopOffset, 0.0f, 630.0f);
        itemTopOffset = itemTopOffset + 630.0f + 100.0f;
        JPanel scoringOperationsPanel = new JPanel();
        FramerFactory.current.installComponent(scoringOperationsPanel, scoringSectionPanel, 1, 170, 0.0f, itemTopOffset, 0.0f, 0.0f);
        scoringOperationsPanel.setLayout(FramerFactory.current.newLayoutManager());
        int nParmSpecItems = 4;
        float dyParmsPanel = ParameterSpecificationsPanel.computePanelHeight(nParmSpecItems) + 300.0f;
        this.scoringPolicyParmsPanel = new ParameterSpecificationsPanel(4, 1700.0f);
        this.scoringPolicyParmsPanel.setBorder(BorderFactory.createTitledBorder("Scoring Formula Options"));
        FramerFactory.current.installComponent(this.scoringPolicyParmsPanel, scoringOperationsPanel, 1, 136, 0.0f, 0.0f, scoringFormulaWidth, dyParmsPanel);
        float leftInsetGenerateOps = scoringFormulaWidth + 250.0f;
        float leftInsetViewOps = leftInsetGenerateOps + 2000.0f;
        itemTopOffset = 0.0f;
        this.computeResultsButton = new JButton();
        this.computeResultsButton.setText("Generate reports");
        this.computeResultsButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.computeResultsButton, scoringOperationsPanel, 1, 136, leftInsetGenerateOps, itemTopOffset, 1695.0f, 315.0f);
        this.reportFormatOptionsPanel = new ReportFormatOptionsPanel();
        FramerFactory.current.installComponent(this.reportFormatOptionsPanel, scoringOperationsPanel, 1, 136, leftInsetGenerateOps, itemTopOffset += 415.0f, 1800.0f, 1500.0f);
        itemTopOffset = 0.0f;
        this.viewReportOperationsPanel = new ReportViewOperationsPanel();
        FramerFactory.current.installComponent(this.viewReportOperationsPanel, scoringOperationsPanel, 1, 136, leftInsetViewOps, itemTopOffset, 1800.0f, 1700.0f);
    }

    private SeriesScoringTool myApp() {
        return (SeriesScoringTool)this.getAppModel();
    }

    protected abstract String seriesFlavor();

    protected void initOperationActions() {
        this.openCorrectionsLogAction = new OperationAction("Corrections Log", "Notes on corrections you make to series results data", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SeriesScoringToolWindow.this.openCorrectionsLog();
            }
        });
        this.generateReportsAction = new OperationAction("Generate Reports", "Generate " + this.seriesFlavor() + " standings reports for the selected scoring policies", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SeriesScoringToolWindow.this.generateStandingsReports();
            }
        });
        this.viewHTMLReportsAction = new OperationAction("View HTML Reports", "View all standings reports for this " + this.seriesFlavor() + " in HTML (web) format", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SeriesScoringToolWindow.this.viewHTMLReports();
            }
        });
        this.viewTextReportsAction = new OperationAction("View Text Reports", "View all standings reports for this " + this.seriesFlavor() + " in text format", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SeriesScoringToolWindow.this.viewTextReports();
            }
        });
        this.viewPdfReportsAction = new OperationAction("View PDF Reports", "View all standings reports for this " + this.seriesFlavor() + " in PDF format", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SeriesScoringToolWindow.this.viewPdfReports();
            }
        });
        this.viewReportsAction = new OperationAction("View Reports...", "View selected " + this.seriesFlavor() + " standings reports", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SeriesScoringToolWindow.this.viewReports();
            }
        });
        this.deleteReportsAction = new OperationAction("Delete Reports", "Delete all scoring reports for the " + this.seriesFlavor() + " standings.", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SeriesScoringToolWindow.this.deleteReports();
            }
        });
    }

    protected void configureRaceSeriesItemConnections() {
        this.myApp().getRaceSeriesHolder().getNumberOfRacesHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                SeriesScoringToolWindow.this.updateReportOperationItems();
            }
        });
    }

    protected void configureScoringOperationItemConnections() {
        this.scoringPoliciesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    SeriesScoringToolWindow.this.selectScoringPolicy((ScoringPolicySpecification)event.getItem());
                }
            }
        });
        this.computeResultsButton.setAction(this.generateReportsAction);
        this.reportFormatOptionsPanel.generateHTMLReportsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SeriesScoringToolWindow.this.myApp().getGenerateHTMLReportsHolder().setValue(SeriesScoringToolWindow.this.reportFormatOptionsPanel.generateHTMLReportsCheckBox.isSelected());
                SeriesScoringToolWindow.this.updateReportOperationItems();
            }
        });
        this.reportFormatOptionsPanel.generateTextReportsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SeriesScoringToolWindow.this.myApp().getGenerateTextReportsHolder().setValue(SeriesScoringToolWindow.this.reportFormatOptionsPanel.generateTextReportsCheckBox.isSelected());
                SeriesScoringToolWindow.this.updateReportOperationItems();
            }
        });
        this.reportFormatOptionsPanel.generatePrintReportsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SeriesScoringToolWindow.this.myApp().getGeneratePdfReportsHolder().setValue(SeriesScoringToolWindow.this.reportFormatOptionsPanel.generatePrintReportsCheckBox.isSelected());
                SeriesScoringToolWindow.this.updateReportOperationItems();
            }
        });
        this.viewReportOperationsPanel.viewHTMLReportsButton.setAction(this.viewHTMLReportsAction);
        this.viewReportOperationsPanel.viewTextReportsButton.setAction(this.viewTextReportsAction);
        this.viewReportOperationsPanel.viewPdfReportsButton.setAction(this.viewPdfReportsAction);
        this.viewReportOperationsPanel.viewReportsButton.setAction(this.viewReportsAction);
    }

    protected void updateReportOperationItems() {
        int nRaces = this.myApp().getRaceSeriesHolder().getNumberOfRacesHolder().getValue();
        if (nRaces == 0) {
            this.generateReportsAction.setEnabled(false);
            this.viewHTMLReportsAction.setEnabled(false);
            this.viewTextReportsAction.setEnabled(false);
            this.viewPdfReportsAction.setEnabled(false);
            this.viewReportsAction.setEnabled(false);
            return;
        }
        this.generateReportsAction.setEnabled(this.reportFormatOptionsPanel.hasFormatsChecked());
        boolean htmlReportsAvailable = false;
        boolean textReportsAvailable = false;
        boolean pdfReportsAvailable = false;
        ScoringPolicySpecification selectedPolicySpec = this.myApp().getSelectedScoringPolicySpecification();
        if (this.myApp().hasHTMLReportsAvailable(selectedPolicySpec)) {
            htmlReportsAvailable = true;
        }
        if (this.myApp().hasTextReportsAvailable(selectedPolicySpec)) {
            textReportsAvailable = true;
        }
        if (this.myApp().hasPdfReportsAvailable(selectedPolicySpec)) {
            pdfReportsAvailable = true;
        }
        this.viewHTMLReportsAction.setEnabled(htmlReportsAvailable);
        this.viewTextReportsAction.setEnabled(textReportsAvailable);
        this.viewPdfReportsAction.setEnabled(pdfReportsAvailable);
        this.viewReportsAction.setEnabled(this.myApp().getReportsDirectory().exists() && FileSystemServices.getCurrent().getDirectorySize(this.myApp().getReportsDirectory()) > 0);
    }

    protected void updateScoringPolicyItems() {
        ScoringPolicySpecification selectedSpec = this.myApp().getSelectedScoringPolicySpecification();
        this.scoringPolicyDescription.setText(selectedSpec.getDescription());
        this.scoringPolicyParmsPanel.installParameterValues(selectedSpec);
    }

    protected void deleteReports() {
        this.myApp().deleteScoringReports();
        this.updateReportOperationItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateStandingsReports() {
        ScoringPolicySpecification policySpec = this.myApp().getSelectedScoringPolicySpecification();
        if (!this.scoringPolicyParmsPanel.collectParameterValues(policySpec)) {
            return;
        }
        int nProblemsRaces = this.myToolServices().reconcileAllSeriesRaces(this.myApp().getRaceSeries(), false, this.frameWindow);
        if (nProblemsRaces > 0) {
            return;
        }
        Cursor originalCursor = this.frameWindow.getCursor();
        try {
            this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.generateStandingsReports(policySpec);
        }
        finally {
            this.frameWindow.setCursor(originalCursor);
        }
        this.updateReportOperationItems();
    }

    protected void generateStandingsReports(ScoringPolicySpecification policySpec) {
        int nStandingsGenerated;
        try {
            nStandingsGenerated = this.myApp().generateStandingsReports(policySpec);
        }
        catch (RaceDataIOException ex) {
            this.reportReportGenerationFailure(ex);
            return;
        }
        catch (RuntimeException ex) {
            this.reportReportGenerationFailure(ex);
            return;
        }
        if (nStandingsGenerated == 0) {
            MessageDialog.displayMessage("Not a Supported Scoring Policy", "The " + policySpec.getName() + " scoring is not supported for this race series.", this.frameWindow);
            return;
        }
        if (nStandingsGenerated == -1) {
            MessageDialog.displayMessage("No Report Format", "Please select one or more formats for generating the standings reports.", this.frameWindow);
            return;
        }
    }

    protected JFileChooser getReportFilesChooser() {
        if (this.reportFilesChooser == null) {
            this.reportFilesChooser = this.myToolServices().constructReportFilesChooser(this.myApp().getReportsDirectory());
        }
        return this.reportFilesChooser;
    }

    protected void openCorrectionsLog() {
        try {
            this.myApp().openCorrectionsLog();
        }
        catch (IOException ex) {
            MessageDialog.displayError("Unable to open Corrections Log", "I/O error: " + ex.getMessage(), this.frameWindow);
        }
    }

    protected void reportReportGenerationFailure(Exception ex) {
        DebugSupport.current().dumpStack(ex);
        String errorMessage = ex.getMessage();
        if (errorMessage == null) {
            errorMessage = "" + ex;
        }
        MessageDialog.displayError("Error Generating Reports", errorMessage, this.frameWindow);
    }

    protected void selectScoringPolicy(ScoringPolicySpecification spec) {
        this.myApp().selectScoringPolicy(spec);
        this.updateScoringPolicyItems();
        this.updateReportOperationItems();
    }

    protected void viewHTMLReports() {
        ScoringPolicySpecification policySpec = this.myApp().getSelectedScoringPolicySpecification();
        Cursor originalCursor = this.frameWindow.getCursor();
        try {
            this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.myApp().viewHTMLReports(policySpec);
        }
        finally {
            this.frameWindow.setCursor(originalCursor);
        }
    }

    protected void viewPdfReports() {
        ScoringPolicySpecification policySpec = this.myApp().getSelectedScoringPolicySpecification();
        Cursor originalCursor = this.frameWindow.getCursor();
        try {
            this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.myApp().viewPdfReports(policySpec);
        }
        finally {
            this.frameWindow.setCursor(originalCursor);
        }
    }

    protected void viewTextReports() {
        ScoringPolicySpecification policySpec = this.myApp().getSelectedScoringPolicySpecification();
        Cursor originalCursor = this.frameWindow.getCursor();
        try {
            this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.myApp().viewTextReports(policySpec);
        }
        finally {
            this.frameWindow.setCursor(originalCursor);
        }
    }

    protected void viewReports() {
        JFileChooser fd = this.getReportFilesChooser();
        int option = fd.showOpenDialog(this.frameWindow);
        if (option != 0) {
            return;
        }
        File[] selectedFiles = fd.getSelectedFiles();
        if (selectedFiles.length == 0) {
            return;
        }
        for (int i = 0; i < selectedFiles.length; ++i) {
            this.myApp().viewReport(selectedFiles[i]);
        }
    }
}

