/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.OperatingSystemHelper;
import com.glaivestone.javax.io.FileType;
import com.glaivestone.javax.lang.ConstantValue;
import com.glaivestone.javax.lang.ConstantValueWithDescription;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.OperationAction;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.UISessionManager;
import com.glaivestone.mv.swing.ConfigurableListCellRenderer;
import com.glaivestone.mv.swing.ReadOnlyTableCellRenderer;
import com.glaivestone.mv.swing.ValueRenderer;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceDataServices;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.racedata.reports.RaceDataReportServices;
import org.ussamasters.aces.tools.foundation.models.RaceScoringSessionManager;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.foundation.models.WorkingSetTool;
import org.ussamasters.aces.tools.foundation.settings.SessionRootSettings;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.foundation.swing.UserConfirmationValidationResolver;
import org.ussamasters.aces.tools.ui.EditConfigurationSettingsDialog;
import org.ussamasters.aces.tools.ui.NewWorkingSetDialog;
import org.ussamasters.aces.tools.ui.RaceCompetitorsReconcilationResult;
import org.ussamasters.aces.tools.ui.RaceCompetitorsReconciliationViewer;
import org.ussamasters.aces.tools.ui.RaceDataTool;
import org.ussamasters.aces.tools.ui.RaceResultReconcilationResult;
import org.ussamasters.aces.tools.ui.RaceResultReconciliationViewer;
import org.ussamasters.aces.tools.ui.RacerListEditor;
import org.ussamasters.aces.tools.ui.RacerListImportTool;
import org.ussamasters.aces.tools.ui.RacerListReconciliationResultViewer;
import org.ussamasters.aces.tools.ui.swing.AboutDialogWindow;

public class ToolUIServices {
    public static ToolUIServices current = new ToolUIServices();
    public static final ValueRenderer CONSTANT_NAME_RENDERER = new ValueRenderer(){

        @Override
        public String toDisplayString(Object aValue) {
            return ((ConstantValue)aValue).name;
        }
    };
    public static final ValueRenderer CONSTANT_DESCRIPTION_RENDERER = new ValueRenderer(){

        @Override
        public String toDisplayString(Object aValue) {
            return ((ConstantValueWithDescription)aValue).description;
        }
    };
    public static final ValueRenderer RACE_CLASS_TYPE_RENDERER = new ValueRenderer(){

        @Override
        public String toDisplayString(Object aValue) {
            return RaceDataIOServices.raceClassTypeToLiteral((RaceClassType)aValue);
        }
    };
    public static final ValueRenderer WORLD_CUP_POINTS_TYPE_RENDERER = new ValueRenderer(){

        @Override
        public String toDisplayString(Object aValue) {
            return RaceDataIOServices.worldCupPointsTypeToLiteral((WorldCupPointsType)((Object)aValue));
        }
    };
    public static final ValueRenderer RACE_LOCATION_RENDERER = new ValueRenderer(){

        @Override
        public String toDisplayString(Object aValue) {
            return ((RaceLocation)aValue).fullName;
        }
    };
    public static final ValueRenderer POLICY_ID_RENDERER = new ValueRenderer(){

        @Override
        public String toDisplayString(Object aValue) {
            return ((PolicyID)aValue).description;
        }
    };
    protected JTextField nopCellEditorField = new JTextField();
    protected List<FileFilter> reportsFileChooserFilters;

    protected ToolUIServices() {
    }

    public JMenuItem appendApplicationCloseItem(JMenu aMenu, final ApplicationView aView) {
        OperationAction ma = new OperationAction("Close", "Close the application", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                aView.requestCloseWindow();
            }
        });
        JMenuItem mi = ma.appendTo(aMenu);
        return mi;
    }

    public void appendRaceSeriesWorkingSetItems(JMenu aMenu, ApplicationView aView) {
        this.appendRaceSeriesWorkingSetItems(aMenu, aView, (RaceDataTool)aView.getAppModel());
    }

    protected void appendRaceSeriesWorkingSetItems(JMenu aMenu, final ApplicationView aView, RaceDataTool theApp) {
        boolean switchingSupported = theApp.supportsWorkingSetSwitching();
        OperationAction ma = new OperationAction("New...", "Create a new race series", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ToolUIServices.this.newWorkingSet(aView);
            }
        });
        JMenuItem mi = ma.appendTo(aMenu);
        if (!switchingSupported) {
            mi.setEnabled(false);
        }
        ma = new OperationAction("Open...", "Open the race data for a different race series", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ToolUIServices.this.openWorkingSet(aView);
            }
        });
        mi = ma.appendTo(aMenu);
        if (!switchingSupported) {
            mi.setEnabled(false);
        }
        aMenu.addSeparator();
        ma = new OperationAction("Settings...", "Edit the configuration settings.", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ToolUIServices.this.editConfigurationSettings(aView);
            }
        });
        mi = ma.appendTo(aMenu);
    }

    public JMenu buildStandardFileMenu(ApplicationView aView) {
        RaceDataTool theApp = (RaceDataTool)aView.getAppModel();
        JMenu aMenu = this.constructFileMenu();
        if (theApp.supportsWorkingSetSwitching()) {
            this.appendRaceSeriesWorkingSetItems(aMenu, aView, theApp);
            aMenu.addSeparator();
        }
        this.appendApplicationCloseItem(aMenu, aView);
        return aMenu;
    }

    public JMenu buildStandardHelpMenu(final ApplicationView aView) {
        JMenu aMenu = this.constructHelpMenu();
        JMenuItem mi = new JMenuItem("Help for <tool>");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MessageDialog.displayMessage("Not Yet Available", "Directly linking to Help information on this tool is not yet available.\n\nPlease locate the desired information in the User's Guide.", aView.getMainWindow());
            }
        });
        aMenu.add(mi);
        aMenu.addSeparator();
        mi = new JMenuItem("Doc Index");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ToolUIServices.this.openDocIndex(aView);
            }
        });
        aMenu.add(mi);
        mi = new JMenuItem("User's Guide");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ToolUIServices.this.openUsersGuide(aView);
            }
        });
        aMenu.add(mi);
        aMenu.addSeparator();
        mi = this.constructAboutMenuItem(aView);
        aMenu.add(mi);
        return aMenu;
    }

    protected JMenuItem constructAboutMenuItem(final ApplicationView aView) {
        String toolName = this.getToolDisplayName(aView);
        toolName = null;
        String label = toolName != null ? "About " + toolName : "About";
        JMenuItem mi = new JMenuItem(label);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AboutDialogWindow.openFor(aView);
            }
        });
        return mi;
    }

    public FileFilter constructFileFilter(final FileType aFileType) {
        final String extensionSuffix = aFileType.composeFileName("").toLowerCase();
        return new FileFilter(){

            @Override
            public boolean accept(File aFile) {
                return aFile.getName().toLowerCase().endsWith(extensionSuffix);
            }

            @Override
            public String getDescription() {
                return aFileType.description + " (*" + extensionSuffix + ")";
            }
        };
    }

    public JMenu constructFileMenu() {
        JMenu aMenu = new JMenu("File");
        aMenu.setToolTipText("General application and file operations");
        return aMenu;
    }

    public JMenu constructHelpMenu() {
        JMenu aMenu = new JMenu("Help");
        aMenu.setToolTipText("Help for the application");
        return aMenu;
    }

    public OperationAction constructImportRacerListAction(ApplicationView aView) {
        return new OperationAction("Import Racers", "Import competitors into the series racer list from a timing system data file", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RacerListImportTool.findOrOpen();
            }
        });
    }

    public OperationAction constructLaunchRacerListEditorAction() {
        return this.constructLaunchToolAction(RacerListEditor.TOOL_ID, "Edit Racer List", "Browse or edit the list of registered competitors.");
    }

    public OperationAction constructLaunchToolAction(ToolID toolID, String label, String description) {
        final ToolInfo toolInfo = this.getSessionManager().getToolInfo(toolID);
        final boolean isToolAvailable = toolInfo != null && toolInfo.getOpenAction() != null;
        OperationAction ma = new OperationAction(label, description, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (isToolAvailable) {
                    toolInfo.openTool();
                }
            }
        });
        if (!isToolAvailable) {
            ma.setEnabled(false);
        }
        return ma;
    }

    public TableCellEditor constructNoEditTableCellEditor() {
        return new DefaultCellEditor(this.nopCellEditorField){

            @Override
            public boolean isCellEditable(EventObject event) {
                return false;
            }
        };
    }

    public DefaultTableCellRenderer constructNoEditTableCellRenderer() {
        return new ReadOnlyTableCellRenderer();
    }

    public OperationAction constructReconcileRaceCompetitorsAction(ActionListener handler) {
        return new OperationAction("Reconcile", "Reconcile the competitors in the selected race against the registered racers list", handler);
    }

    public JFileChooser constructReportFilesChooser(File aDirectory) {
        if (this.reportsFileChooserFilters == null) {
            this.reportsFileChooserFilters = new ArrayList<FileFilter>();
            for (int i = 0; i < RaceDataReportServices.ALL_REPORT_TYPES.length; ++i) {
                this.reportsFileChooserFilters.add(this.constructFileFilter(RaceDataReportServices.ALL_REPORT_TYPES[i]));
            }
        }
        JFileChooser fd = new JFileChooser();
        for (FileFilter aFilter : this.reportsFileChooserFilters) {
            fd.addChoosableFileFilter(aFilter);
        }
        fd.setAcceptAllFileFilterUsed(true);
        fd.setMultiSelectionEnabled(true);
        fd.setCurrentDirectory(aDirectory);
        return fd;
    }

    public OperationAction constructSaveAction(String toolTip, ActionListener saveAction) {
        OperationAction anAction = new OperationAction("Save", toolTip, saveAction);
        anAction.putValue("MnemonicKey", new Integer(83));
        anAction.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        return anAction;
    }

    public JMenu constructScoringMenu() {
        JMenu aMenu = new JMenu("Scoring");
        aMenu.setToolTipText("Series scoring");
        return aMenu;
    }

    public void editConfigurationSettings(ApplicationView requestingView) {
        Window clientWindow = requestingView.getMainWindow();
        EditConfigurationSettingsDialog.openFor(clientWindow);
    }

    public UserConfirmationValidationResolver constructUserConfirmationValidationResolver(Window clientWindow) {
        return new UserConfirmationValidationResolver(clientWindow);
    }

    public RaceClass<?> editRacerResultClass(RaceEntryResult aRacerResult, Window clientWindow) {
        RaceClass<?> currentRaceClass = aRacerResult.getRaceClass();
        Class<?> raceClassClass = currentRaceClass.getClass();
        ArrayList raceClasses = new ArrayList();
        for (RaceClass<?> aRaceClass : RaceClass.getRaceClassValues(raceClassClass)) {
            if (!aRaceClass.isAgeGroupClass()) continue;
            raceClasses.add(aRaceClass);
        }
        Collections.sort(raceClasses, new Comparator<RaceClass<?>>(){

            @Override
            public int compare(RaceClass<?> c1, RaceClass<?> c2) {
                return c1.compareAge(c2);
            }
        });
        RaceClass<?>[] abilityGroupClasses = RaceClass.getAbilityGroupClassConstants(raceClassClass);
        if (abilityGroupClasses != null) {
            for (int i = 0; i < abilityGroupClasses.length; ++i) {
                raceClasses.add(abilityGroupClasses[i]);
            }
        }
        int nClasses = raceClasses.size();
        Object[] raceClassNames = new String[nClasses];
        for (int i = 0; i < nClasses; ++i) {
            raceClassNames[i] = ((RaceClass)raceClasses.get((int)i)).name;
        }
        String newClassName = (String)JOptionPane.showInputDialog(clientWindow, "Corrected class:", "Correct Racer Class", -1, null, raceClassNames, currentRaceClass.name);
        if (newClassName == null) {
            return null;
        }
        for (RaceClass raceClass : raceClasses) {
            if (!newClassName.equals(raceClass.name)) continue;
            return raceClass;
        }
        return null;
    }

    public String[] editRacerResultName(RaceEntryResult aRacerResult, Window clientWindow) {
        String currentName = aRacerResult.getLastName() + ", " + aRacerResult.getFirstName();
        String editedName = (String)JOptionPane.showInputDialog(clientWindow, "Corrected name:", "Correct Racer Name", -1, null, null, currentName);
        if (editedName == null) {
            return null;
        }
        if ((editedName = editedName.trim()).equals(currentName)) {
            return null;
        }
        int sepIndex = editedName.indexOf(",");
        if (sepIndex == -1) {
            MessageDialog.displayWarning("Invalid Name Edit", "Name must be in the form 'lastName, firstName'", clientWindow);
            return null;
        }
        String lastName = editedName.substring(0, sepIndex).trim();
        String firstName = editedName.substring(sepIndex + 1).trim();
        if (lastName.length() == 0 || firstName.length() == 0) {
            MessageDialog.displayWarning("Invalid Name Edit", "Name must be in the form 'lastName, firstName'", clientWindow);
            return null;
        }
        if (lastName.equals(aRacerResult.getLastName()) && firstName.equals(aRacerResult.getFirstName())) {
            return null;
        }
        return new String[]{lastName, firstName};
    }

    public CompetitorResultValue<?> editRacerRunResult(CompetitorResultValue<?> currentResultValue, Window clientWindow) {
        CompetitorResultValue<?> newResultValue;
        String editedResult = (String)JOptionPane.showInputDialog(clientWindow, "Corrected value (DNS, DNF, DSQ, or time):", "Correct Racer Run Result", -1, null, null, currentResultValue.toString());
        if (editedResult == null) {
            return null;
        }
        try {
            newResultValue = RaceDataServices.current.raceResultValueFromString(editedResult);
        }
        catch (IllegalArgumentException ex) {
            MessageDialog.displayError("Invalid Result Value", "Please enter a status code (DNS, DNF, DSQ) or run time (sss.hh or m:ss.hh).", clientWindow);
            return null;
        }
        if (newResultValue == null) {
            MessageDialog.displayWarning("Invalid Result Value", "Please enter a status code (DNS, DNF, DSQ) or run time (sss.hh or m:ss.hh).", clientWindow);
            return null;
        }
        if (newResultValue.equals(currentResultValue)) {
            return null;
        }
        return newResultValue;
    }

    public RaceScoringSessionManager getSessionManager() {
        return RaceScoringSessionManager.getCurrent();
    }

    public String getToolDisplayName(ApplicationView aView) {
        ToolInfo toolInfo;
        ToolID toolID;
        if (aView.getAppModel() instanceof WorkingSetTool && (toolID = ((WorkingSetTool)((Object)aView.getAppModel())).getToolID()) != null && (toolInfo = this.getSessionManager().getToolInfo(toolID)) != null) {
            return toolInfo.getDisplayName();
        }
        return null;
    }

    public boolean handlePanePopup(JComponent aPane, JPopupMenu popupMenu, MouseEvent event) {
        if (event.isPopupTrigger()) {
            popupMenu.show(aPane, event.getX(), event.getY());
            return true;
        }
        return false;
    }

    public void installConstantDescriptionRenderer(JComboBox<?> comboBox) {
        comboBox.setRenderer(new ConfigurableListCellRenderer(CONSTANT_DESCRIPTION_RENDERER));
    }

    public void installConstantNameRenderer(JComboBox<?> comboBox) {
        comboBox.setRenderer(new ConfigurableListCellRenderer(CONSTANT_NAME_RENDERER));
    }

    public void installRaceLocationRenderer(JComboBox<?> comboBox) {
        comboBox.setRenderer(new ConfigurableListCellRenderer(RACE_LOCATION_RENDERER));
    }

    public void installRenderer(JComboBox<?> comboBox, ValueRenderer renderer) {
        comboBox.setRenderer(new ConfigurableListCellRenderer(renderer));
    }

    public void installNoDirectEditLAF(JTable aTablePane) {
        TableCellEditor editor = this.constructNoEditTableCellEditor();
        DefaultTableCellRenderer renderer = this.constructNoEditTableCellRenderer();
        aTablePane.setDefaultEditor(TableColumn.class, editor);
        aTablePane.setDefaultRenderer(TableColumn.class, renderer);
        for (int i = 0; i < aTablePane.getColumnCount(); ++i) {
            aTablePane.getColumnModel().getColumn(i).setCellEditor(editor);
            aTablePane.getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
    }

    public void installRaceClassTypeRenderer(JComboBox<?> comboBox) {
        comboBox.setRenderer(new ConfigurableListCellRenderer(RACE_CLASS_TYPE_RENDERER));
    }

    public void installWorldCupPointsRenderer(JComboBox<?> comboBox) {
        comboBox.setRenderer(new ConfigurableListCellRenderer(WORLD_CUP_POINTS_TYPE_RENDERER));
    }

    public void newWorkingSet(ApplicationView requestingView) {
        Window clientWindow = requestingView.getMainWindow();
        File newWorkingSetDirectory = NewWorkingSetDialog.openFor(clientWindow);
        if (newWorkingSetDirectory == null) {
            return;
        }
        this.openWorkingSet(newWorkingSetDirectory, requestingView);
    }

    protected void openDocIndex(ApplicationView clientView) {
        String docIndexFileName = "DocIndex.html";
        File docIndexFile = new File(SessionRootSettings.getCurrent().getHelpDirectory().getParentFile(), docIndexFileName);
        try {
            OperatingSystemHelper.current().openFile(docIndexFile);
        }
        catch (IOException ex) {
            DebugSupport.current().dump("***Error: Unable to open Doc Index file " + docIndexFile.getAbsolutePath());
            DebugSupport.current().dumpStack(ex);
            MessageDialog.displayError("Unable to Open Doc Index", "Unable to open the ACES Scoring documentation index: \n\n" + ex.getMessage(), clientView.getMainWindow());
        }
    }

    protected void openTimingDataFormatsDoc(ApplicationView clientView) {
        String docFileName = "FileFormats\\TimingDataFileFormats.html";
        File docFile = new File(SessionRootSettings.getCurrent().getHelpDirectory(), docFileName);
        try {
            OperatingSystemHelper.current().openFile(docFile);
        }
        catch (IOException ex) {
            DebugSupport.current().dump("***Error: Unable to open Timing Data Formats doc file " + docFile.getAbsolutePath());
            DebugSupport.current().dumpStack(ex);
            MessageDialog.displayError("Unable to Open Timing Data Formats documentation", "Unable to open the ACES Scoring timing data formats documentation: \n\n" + ex.getMessage(), clientView.getMainWindow());
        }
    }

    protected void openUsersGuide(ApplicationView clientView) {
        String usersGuideFileName = "ACESUserGuide.html";
        File usersGuideFile = new File(SessionRootSettings.getCurrent().getHelpDirectory(), usersGuideFileName);
        try {
            OperatingSystemHelper.current().openFile(usersGuideFile);
        }
        catch (IOException ex) {
            DebugSupport.current().dump("***Error: Unable to open User's Guide file " + usersGuideFile.getAbsolutePath());
            DebugSupport.current().dumpStack(ex);
            MessageDialog.displayError("Unable to Open User's Guide", "Unable to open the ACE Scoring Uer's Guide: \n\n" + ex.getMessage(), clientView.getMainWindow());
        }
    }

    public void openWorkingSet(ApplicationView requestingView) {
        Window clientWindow = requestingView.getMainWindow();
        List<WorkingSetSettings> wsSettingsList = this.getSessionManager().getAvailableWorkingSets();
        int nWorkingSets = wsSettingsList.size();
        if (nWorkingSets == 0) {
            MessageDialog.displayMessage("No Other Race Series", "There are no other race series defined.", clientWindow);
            return;
        }
        Collections.sort(wsSettingsList, new Comparator<WorkingSetSettings>(){

            @Override
            public int compare(WorkingSetSettings wss1, WorkingSetSettings wss2) {
                return wss1.getDescription().compareTo(wss2.getDescription());
            }
        });
        Object[] wsNames = new String[nWorkingSets];
        String badWorkingSetBackstop = "(bad race series working set)";
        for (int i = 0; i < nWorkingSets; ++i) {
            wsNames[i] = wsSettingsList.get(i).getDescription();
        }
        String currentWorkingSetName = WorkingSetSettings.getCurrent().getDescription();
        if (nWorkingSets == 1 && wsNames[0].equals(currentWorkingSetName)) {
            MessageDialog.displayMessage("No Other Race Series", "There are no other race series defined.", clientWindow);
            return;
        }
        String newWorkingSetName = (String)JOptionPane.showInputDialog(clientWindow, "Race Series:", "Open Race Series", -1, null, wsNames, currentWorkingSetName);
        if (newWorkingSetName == null) {
            return;
        }
        if (newWorkingSetName.equals(badWorkingSetBackstop)) {
            return;
        }
        int selectedIndex = Arrays.binarySearch(wsNames, newWorkingSetName);
        WorkingSetSettings newWorkingSetSettings = wsSettingsList.get(selectedIndex);
        File newWorkingSetDirectory = newWorkingSetSettings.getDirectory();
        this.openWorkingSet(newWorkingSetDirectory, requestingView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openWorkingSet(File workingSetDirectory, ApplicationView requestingView) {
        Window clientWindow = requestingView.getMainWindow();
        for (Window aWindow : UISessionManager.current.getOpenWindows()) {
            boolean closeAccepted;
            ApplicationView aView;
            if (!(aWindow instanceof ApplicationView) || !((aView = (ApplicationView)((Object)aWindow)).getAppModel() instanceof RaceDataTool) || ((RaceDataTool)aView.getAppModel()).supportsWorkingSetSwitching() || (closeAccepted = aView.requestCloseWindow())) continue;
            return;
        }
        Cursor originalCursor = clientWindow.getCursor();
        File originalWorkingSetDirectory = this.getSessionManager().getWorkingSetDirectory();
        try {
            clientWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.getSessionManager().openWorkingSet(workingSetDirectory);
        }
        catch (Exception ex) {
            DebugSupport.current().dump("ERROR: Unable to open working set in " + workingSetDirectory.getAbsolutePath());
            DebugSupport.current().dumpStack(ex);
            MessageDialog.displayError("Unable to Open Race Series", "Unable to open race series stored in " + workingSetDirectory.getAbsolutePath() + ".\n\nError: " + ex.getLocalizedMessage(), clientWindow);
            try {
                this.getSessionManager().openWorkingSet(originalWorkingSetDirectory);
            }
            catch (Exception ex2) {
                DebugSupport.current().dump("ERROR: Unable to revert to original working set in " + originalWorkingSetDirectory.getAbsolutePath());
                DebugSupport.current().dumpStack(ex2);
            }
        }
        finally {
            clientWindow.setCursor(originalCursor);
        }
    }

    public int reconcileAllSeriesRaces(RaceSeries raceSeries, boolean notifyUserOfSuccess, Window clientWindow) {
        int nProblemRaces = 0;
        for (RaceResult seriesRaceResult : raceSeries.getRaceResults()) {
            RacerListReconciliationResultViewer reconcilationViewer = this.reconcileCompetitors(seriesRaceResult);
            if (reconcilationViewer == null) continue;
            ++nProblemRaces;
        }
        if (nProblemRaces == 0) {
            if (notifyUserOfSuccess) {
                MessageDialog.displayMessage("Race Results Reconciled", "All competitors in the series are registered in the series racer list.  No problems found.", clientWindow);
            }
        } else {
            MessageDialog.displayMessage("Race Result Reconciliation Problems", "" + nProblemRaces + " of " + raceSeries.size() + " race results have compeititors who need to be reconciled with the series racer list.\n\nReconcilation reports are displayed so you can resolve problems.", clientWindow);
        }
        return nProblemRaces;
    }

    protected RacerListReconciliationResultViewer reconcileCompetitors(RaceResult aRaceResult) {
        RacerList competitorInfo;
        try {
            competitorInfo = this.getSessionManager().getRaceResultCompetitorInfo(aRaceResult.getRaceId());
        }
        catch (RaceDataIOException ex) {
            competitorInfo = null;
        }
        if (competitorInfo != null) {
            RaceCompetitorsReconcilationResult reconcilationResult = RaceCompetitorsReconcilationResult.reconcileCompetitors(competitorInfo, this.getSessionManager().getRacerList());
            if (reconcilationResult.hasUnreconciledRacers()) {
                RaceCompetitorsReconciliationViewer reconcilationViewer = new RaceCompetitorsReconciliationViewer(aRaceResult.getRaceId(), reconcilationResult);
                reconcilationViewer.openWindow();
                return reconcilationViewer;
            }
        } else {
            RaceResultReconcilationResult reconciliationResult = RaceResultReconcilationResult.reconcileCompetitors(aRaceResult, this.getSessionManager().getRacerList());
            if (reconciliationResult.hasUnreconciledRacers()) {
                RaceResultReconciliationViewer reconcilationViewer = new RaceResultReconciliationViewer(reconciliationResult);
                reconcilationViewer.openWindow();
                return reconcilationViewer;
            }
        }
        return null;
    }

    public void reconcileRaceResult(RaceResult aRaceResult, Window clientWindow) {
        if (aRaceResult == null) {
            MessageDialog.displayMessage("No Race Selected", "Please select the race whose competitors you wish to validate to ensure that all competitors are entered in the series racers list.", clientWindow);
            return;
        }
        RacerListReconciliationResultViewer reconciliationResultViewer = this.reconcileCompetitors(aRaceResult);
        if (reconciliationResultViewer == null) {
            MessageDialog.displayMessage("Race Result Reconciled", "All competitors in this race are registered in the series racer list.  No problems found.", clientWindow);
        }
        if (aRaceResult != null) {
            this.getSessionManager().markResultReconciled(aRaceResult.getRaceId());
        }
    }

    public void registerDoubleClickHandler(JComponent aComponent, final ActionListener anAction) {
        aComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    anAction.actionPerformed(null);
                }
            }
        });
    }

    public void registerDoubleClickHandler(JComponent aComponent, final EvaluableAction anAction) {
        aComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    anAction.evaluate();
                }
            }
        });
    }

    public void registerPanePopupHandler(final JComponent aComponent, final JPopupMenu aPopupMenu) {
        aComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ToolUIServices.this.handlePanePopup(aComponent, aPopupMenu, event);
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                ToolUIServices.this.handlePanePopup(aComponent, aPopupMenu, event);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                ToolUIServices.this.handlePanePopup(aComponent, aPopupMenu, event);
            }
        });
    }

    public void scrollRowIntoView(int rowIndex, JTable aTablePane) {
        this.scrollRowIntoView(rowIndex, aTablePane, 2);
    }

    public void scrollRowIntoView(int rowIndex, JTable aTablePane, int nPadRows) {
        if (rowIndex == -1) {
            return;
        }
        Rectangle rowRect = aTablePane.getCellRect(rowIndex, 0, true);
        int rowHeight = rowRect.height;
        int yOffset = rowRect.y;
        int height = rowHeight;
        int nExtraRows = Math.min(nPadRows, rowIndex);
        int deltaY = nExtraRows * rowHeight;
        yOffset -= deltaY;
        height += deltaY;
        deltaY = nExtraRows * rowHeight;
        Rectangle targetRect = new Rectangle(rowRect.x, yOffset, rowRect.width, height += deltaY);
        aTablePane.scrollRectToVisible(targetRect);
    }

    public void scrollSelectionIntoView(JTable aTablePane) {
        this.scrollRowIntoView(aTablePane.getSelectionModel().getMinSelectionIndex(), aTablePane);
    }
}

