/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.javax.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ResourceFileAccessor {
    private static final Class<ResourceFileAccessor> THIS_CLASS = ResourceFileAccessor.class;
    private static final char COMMENT_CHAR = '#';

    public static String readFileContents(String fileRef) {
        ResourceFileAccessor accessor = new ResourceFileAccessor();
        return accessor.readFileToString(fileRef);
    }

    public static List<String> readFileLines(String fileRef) {
        ResourceFileAccessor accessor = new ResourceFileAccessor();
        List<String> lines = accessor.readFileAsLines(fileRef);
        if (lines != null) {
            lines = accessor.filterLines(lines);
        }
        return lines;
    }

    public List<String> filterLines(List<String> lines) {
        ArrayList<String> contentLines = new ArrayList<String>(lines.size());
        for (String line : lines) {
            String text = line.trim();
            if (text.isEmpty() || text.charAt(0) == '#') continue;
            contentLines.add(line);
        }
        return contentLines;
    }

    public List<String> readFileAsLines(String fileRef) {
        InputStream fs = this.openFile(fileRef);
        if (fs == null) {
            return null;
        }
        List<String> lines = null;
        try {
            lines = IOUtils.readLines(fs, Charset.defaultCharset());
        }
        catch (IOException ex) {
            System.err.println("***ERROR: Unable to read contents of resource file '" + fileRef + "'");
            ex.printStackTrace();
            return null;
        }
        return lines;
    }

    public String readFileToString(String fileRef) {
        InputStream fs = this.openFile(fileRef);
        if (fs == null) {
            return null;
        }
        String contents = null;
        try {
            contents = IOUtils.toString(fs, Charset.defaultCharset());
        }
        catch (IOException ex) {
            System.err.println("***ERROR: Unable to read contents of resource file '" + fileRef + "'");
            ex.printStackTrace();
            return null;
        }
        return contents;
    }

    public InputStream openFile(String fileRef) {
        File file;
        InputStream fs = THIS_CLASS.getResourceAsStream(fileRef);
        if (fs == null && (file = new File(fileRef)).isFile()) {
            try {
                fs = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return fs;
    }
}

