/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.execution;

import com.glaivestone.javax.execution.SessionManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SessionLauncher {
    public static SessionLauncher current;
    public static final String SYSTEM_PROP_NAME_CLASSPATH = "java.class.path";
    public static final String OPTION_PREFIX = "-";
    public static final String OPTION_VERBOSE = "-verbose";
    public static final String OPTION_DUMP_CP = "-dumpCP";
    public static final String OPTION_DUMP_SYSTEM_PROPS = "-dumpSysProps";
    public static final String OPTION_DUMP_LIBRARY_PROPS = "-dumpLibProps";
    public static final String OPTION_MAIN_CLASS = "-main";
    public static final String DEFAULT_LIB_DIR = "./lib";
    public static final String LIBRARY_PROPS_FILE = "com/glaivestone/resources/version.txt";
    public static final String[] EMPTY_APPLICATION_ARGUMENTS;
    public static final String[] LIBRARY_REPORT_ARGUMENTS;
    public static final String SECTION_SEPARATOR = "===================================================================";
    protected static List<String> NO_ARG_OPTIONS;
    protected static List<String> ONE_ARG_OPTIONS;
    protected String[] arguments;
    protected PrintStream reportStream;
    protected Map<String, String> launcherArguments;
    protected boolean beVerbose;
    protected String mainClassName;
    protected String[] mainClassArguments;

    public SessionLauncher(String[] arguments) {
        this(arguments, System.out);
    }

    public SessionLauncher(String[] arguments, PrintStream reportStream) {
        this.arguments = arguments != null ? arguments : EMPTY_APPLICATION_ARGUMENTS;
        this.reportStream = reportStream;
    }

    public void describeClassPath(PrintStream ps) {
        String classPathSetting = System.getProperty(SYSTEM_PROP_NAME_CLASSPATH);
        StringTokenizer tokenizer = new StringTokenizer(classPathSetting, ";");
        int nEntries = 0;
        ps.println("SYSTEM CLASSPATH ENTRIES:");
        while (tokenizer.hasMoreTokens()) {
            ps.println("   " + tokenizer.nextToken());
            ++nEntries;
        }
        ps.println("(" + nEntries + " CLASSPATH entries)");
        ps.println();
    }

    public void describeLibraryProperties(PrintStream ps) {
        URL libInfoRef = SessionManager.current.getSystemResource(LIBRARY_PROPS_FILE);
        Object libInfo = null;
        ps.println();
        ps.println("======== GFL LIBRARY PROPERTIES ===========");
        ps.println();
        if (libInfoRef != null) {
            try {
                libInfo = libInfoRef.getContent();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (libInfo == null) {
            ps.println("GFL.jar config problem: 'com/glaivestone/resources/version.txt' not found.");
        } else {
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)libInfo));
            try {
                String line;
                while ((line = input.readLine()) != null) {
                    ps.println(line);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        ps.println();
        ps.println("============ END GFL LIBRARY PROPERTIES REPORT =======");
        ps.println();
    }

    public void describeSystemProperties(PrintStream ps) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Object propName : System.getProperties().keySet()) {
            propertyNames.add((String)propName);
        }
        Collections.sort(propertyNames);
        this.describeSystemProperties(propertyNames, ps);
    }

    public void describeSystemProperties(List<String> propertyNames, PrintStream ps) {
        ps.println();
        ps.println("======== SYSTEM PROPERTY SETTINGS ===========");
        ps.println();
        for (String propertyName : propertyNames) {
            ps.println("    " + propertyName + "=" + System.getProperty(propertyName));
        }
        ps.println();
        ps.println("============ END SYSTEM PROPERTIES REPORT =======");
        ps.println();
    }

    public static void flushSystemStreams() {
        System.err.flush();
        System.out.flush();
    }

    public void initiateSession() {
        this.parseCommandLineArguments();
        this.processLauncherArguments();
        this.runMainClass();
    }

    protected void parseCommandLineArguments() {
        this.launcherArguments = new HashMap<String, String>();
        int nArgs = this.arguments.length;
        boolean foundMain = false;
        for (int index = 0; index < nArgs; ++index) {
            String anArg = this.arguments[index];
            if (anArg.startsWith(OPTION_PREFIX)) {
                String optionName = anArg;
                if (NO_ARG_OPTIONS.contains(optionName)) {
                    this.launcherArguments.put(optionName, null);
                    continue;
                }
                if (ONE_ARG_OPTIONS.contains(optionName)) {
                    if (index == nArgs - 1) {
                        throw new IllegalArgumentException("SessionLauncher argument value not specified: " + optionName);
                    }
                    this.launcherArguments.put(optionName, this.arguments[++index]);
                    if (!optionName.equals(OPTION_MAIN_CLASS)) continue;
                    foundMain = true;
                    continue;
                }
                this.reportWarning("Unknown SessionLauncher option: '" + anArg + "'");
                continue;
            }
            this.reportWarning("Unknown SessionLauncher option: '" + anArg + "'");
            if (!foundMain) continue;
            int nMainClassArgs = nArgs - index + 1;
            if (nMainClassArgs == 0) {
                this.mainClassArguments = EMPTY_APPLICATION_ARGUMENTS;
            } else {
                this.mainClassArguments = new String[nMainClassArgs];
                System.arraycopy(this.arguments, index, this.mainClassArguments, 0, nMainClassArgs);
            }
            return;
        }
    }

    protected void processLauncherArguments() {
        File homeDirectory = SessionManager.DEFAULT_DIRECTORY;
        this.beVerbose = this.launcherArguments.containsKey(OPTION_VERBOSE);
        if (this.beVerbose) {
            this.reportStream.println("\n***** SESSION LAUNCHER *****");
            this.reportStream.println("...execution directory: " + homeDirectory.getAbsolutePath());
        }
        if (this.launcherArguments.containsKey(OPTION_DUMP_LIBRARY_PROPS)) {
            this.describeLibraryProperties(this.reportStream);
        }
        this.processLibDir(homeDirectory);
        if (this.launcherArguments.containsKey(OPTION_DUMP_SYSTEM_PROPS)) {
            this.describeSystemProperties(this.reportStream);
        }
        if (this.launcherArguments.containsKey(OPTION_DUMP_CP)) {
            this.describeClassPath(this.reportStream);
        }
    }

    protected void processLibDir(File homeDirectory) {
    }

    protected void reportError(String message, Exception ex) {
        SessionLauncher.flushSystemStreams();
        System.err.println("\n***FATAL LAUNCHER ERROR: " + message);
        if (ex != null) {
            ex.printStackTrace();
        }
        System.err.flush();
        System.exit(0);
    }

    protected void reportWarning(String message) {
        SessionLauncher.flushSystemStreams();
        System.err.println("***WARNING: " + message);
        System.err.flush();
    }

    protected void runMainClass() {
        Class<?> mainClass;
        String mainClassName = this.launcherArguments.get(OPTION_MAIN_CLASS);
        if (mainClassName == null) {
            return;
        }
        try {
            mainClass = Class.forName(mainClassName);
        }
        catch (ClassNotFoundException ex) {
            this.reportError("MAIN CLASS NOT FOUND: " + mainClassName, ex);
            return;
        }
        this.runMain(mainClass, this.mainClassArguments);
    }

    public void runMain(Class<?> mainClass, String[] args) {
        Method mainMethod;
        String selector = "main";
        Class[] parmTypes = new Class[]{EMPTY_APPLICATION_ARGUMENTS.getClass()};
        try {
            mainMethod = mainClass.getMethod(selector, parmTypes);
        }
        catch (NoSuchMethodException ex) {
            this.reportError("no main(String[]) method found - " + mainClass.getName(), ex);
            return;
        }
        if (this.beVerbose) {
            SessionLauncher.flushSystemStreams();
            this.reportStream.println();
            this.reportStream.println("Launching " + mainClass.getName() + ".main(args)");
            this.reportStream.println();
            this.reportStream.println(SECTION_SEPARATOR);
            this.reportStream.println();
            this.reportStream.flush();
        }
        try {
            mainMethod.invoke(mainClass, new Object[]{args});
        }
        catch (Exception ex) {
            this.reportError("main() invocation failed - " + mainClass.getName(), ex);
            return;
        }
    }

    public static void main(String[] arguments) {
        String[] sessionLaunchArgs = arguments == null || arguments.length == 0 ? LIBRARY_REPORT_ARGUMENTS : arguments;
        current = new SessionLauncher(sessionLaunchArgs);
        current.initiateSession();
    }

    static {
        EMPTY_APPLICATION_ARGUMENTS = new String[0];
        LIBRARY_REPORT_ARGUMENTS = new String[]{OPTION_VERBOSE, OPTION_DUMP_CP, OPTION_DUMP_SYSTEM_PROPS, OPTION_DUMP_LIBRARY_PROPS};
        NO_ARG_OPTIONS = Arrays.asList(OPTION_VERBOSE, OPTION_DUMP_CP, OPTION_DUMP_SYSTEM_PROPS, OPTION_DUMP_LIBRARY_PROPS);
        ONE_ARG_OPTIONS = Arrays.asList(OPTION_MAIN_CLASS);
    }
}

