/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.execution;

import com.glaivestone.javax.execution.SessionEvent;
import com.glaivestone.javax.execution.SessionEventListener;
import com.glaivestone.javax.util.EventManager;
import com.glaivestone.javax.util.VetoException;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class SessionManager
extends EventManager {
    public static SessionManager current = new SessionManager();
    public static final File DEFAULT_DIRECTORY;
    public static final Object NULL_VALUE;
    protected Map<String, Object> sessionOptions;

    protected SessionManager() {
        this.initSessionOptions();
    }

    protected void acquireSessionOptions(SessionManager aSessionManager) {
        this.sessionOptions = aSessionManager.sessionOptions;
        aSessionManager.initSessionOptions();
    }

    protected void acquireSessionSettings(SessionManager aSessionManager) {
        this.acquireEventTable(aSessionManager);
        this.acquireSessionOptions(aSessionManager);
    }

    public void addFirstSessionListener(SessionEventListener aListener) {
        this.addFirstListener(aListener, SessionEventListener.class);
    }

    public void addSessionListener(SessionEventListener aListener) {
        this.addListener(aListener, SessionEventListener.class);
    }

    protected void becomeCurrent() {
        if (current != null) {
            this.acquireSessionSettings(current);
        }
        current = this;
    }

    protected Map<String, Object> constructSessionOptionsTable() {
        return new HashMap<String, Object>();
    }

    public void exit() {
        this.fireAboutToShutdownSession();
        System.exit(0);
    }

    public void fireAboutToStartSession() {
        SessionEvent event = new SessionEvent(100, this);
        SessionEventListener[] listeners = this.getSessionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].aboutToStartSession(event);
        }
    }

    protected void fireAboutToShutdownSession() {
        SessionEvent event = new SessionEvent(210, this);
        SessionEventListener[] listeners = this.getSessionListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].aboutToShutdownSession(event);
        }
    }

    protected void fireConfirmSessionShutdown() throws VetoException {
        SessionEvent event = new SessionEvent(200, this);
        SessionEventListener[] listeners = this.getSessionListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].confirmSessionShutdown(event);
        }
    }

    public void fireSessionStarted() {
        SessionEvent event = new SessionEvent(110, this);
        SessionEventListener[] listeners = this.getSessionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].sessionStarted(event);
        }
    }

    public Object getOption(String name) {
        return this.sessionOptions.get(name);
    }

    public Object getOption(String name, Object valueIfAbsent) {
        Object value = this.sessionOptions.get(name);
        if (value == null && !this.hasOption(name)) {
            value = valueIfAbsent;
        }
        return value;
    }

    public URL getSystemResource(String reference) {
        return ClassLoader.getSystemResource(reference);
    }

    protected SessionEventListener[] getSessionListeners() {
        return (SessionEventListener[])this.getListeners(SessionEventListener.class);
    }

    public boolean hasOption(String name) {
        return this.sessionOptions.containsKey(name);
    }

    protected void initSessionOptions() {
        this.sessionOptions = this.constructSessionOptionsTable();
    }

    public void registerOption(String name, Object value) {
        this.sessionOptions.put(name, value);
    }

    public void removeOption(String name) {
        this.sessionOptions.remove(name);
    }

    public void removeSessionListener(SessionEventListener aListener) {
        this.removeListener(aListener, SessionEventListener.class);
    }

    public void shutdown() {
        try {
            this.fireConfirmSessionShutdown();
        }
        catch (VetoException ex) {
            return;
        }
        this.exit();
    }

    public String toString() {
        return this == current ? this.getClass().getName() + ".current" : super.toString();
    }

    static {
        NULL_VALUE = new Object();
        DEFAULT_DIRECTORY = new File(new File("").getAbsolutePath());
    }
}

