/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.lang;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ClassX {
    public static final List<String> PRIMITIVE_TYPE_NAMES = Collections.unmodifiableList(Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short"));
    protected static final String SEPARATOR = ".";

    private ClassX() {
    }

    public static Class<?> classForNameOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }

    protected static String composeSignatureDescription(String messageName, Class<?>[] parmTypes, Class<?> returnType, boolean useSimpleTypeNames) {
        int nParms = parmTypes.length;
        StringBuffer sb = new StringBuffer();
        sb.append(useSimpleTypeNames ? ClassX.getSimpleName(returnType) : returnType.getName());
        sb.append(" ");
        sb.append(messageName);
        sb.append("(");
        for (int i = 0; i < nParms; ++i) {
            sb.append(useSimpleTypeNames ? ClassX.getSimpleName(parmTypes[i]) : parmTypes[i].getName());
            if (i >= nParms - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static Method getMethodOrNull(Class<?> aClass, String messageName, Class<?>[] parmTypes) {
        try {
            return aClass.getMethod(messageName, parmTypes);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    @Deprecated
    public static String getPackageName(Class<?> aClass) {
        return aClass.getPackage().getName();
    }

    public static String getPackageName(String fullyQualifiedName) {
        int separatorIndex = fullyQualifiedName.lastIndexOf(SEPARATOR);
        return separatorIndex < 0 ? null : fullyQualifiedName.substring(0, separatorIndex);
    }

    @Deprecated
    public static String getSimpleName(Class<?> aClass) {
        return aClass.getSimpleName();
    }

    public static String getSimpleName(String fullyQualifiedName) {
        int separatorIndex = fullyQualifiedName.lastIndexOf(SEPARATOR);
        return separatorIndex < 0 ? fullyQualifiedName : fullyQualifiedName.substring(separatorIndex + 1);
    }

    public static boolean isPrimitiveType(String typeName) {
        return PRIMITIVE_TYPE_NAMES.contains(typeName);
    }

    public static boolean isProperSubclass(Class<?> aClass, Class<?> baseClass) {
        if (aClass.isInterface() || baseClass.isInterface()) {
            return false;
        }
        return baseClass.isAssignableFrom(aClass) && !aClass.equals(baseClass);
    }

    public static Object newInstanceOrNull(String className) {
        Class<?> aClass = ClassX.classForNameOrNull(className);
        return aClass != null ? ClassX.newInstanceOrNull(aClass) : null;
    }

    public static Object newInstanceOrNull(Class<?> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            // empty catch block
        }
        return null;
    }

    public static String toSignatureDescription(Method aMethod) {
        return ClassX.toSignatureDescription(aMethod.getName(), aMethod.getParameterTypes(), aMethod.getReturnType());
    }

    public static String toSignatureDescription(String messageName, Class<?>[] parmTypes, Class<?> returnType) {
        return ClassX.composeSignatureDescription(messageName, parmTypes, returnType, false);
    }

    public static String toSimpleSignatureDescription(Method aMethod) {
        return ClassX.toSimpleSignatureDescription(aMethod.getName(), aMethod.getParameterTypes(), aMethod.getReturnType());
    }

    public static String toSimpleSignatureDescription(String messageName, Class<?>[] parmTypes, Class<?> returnType) {
        return ClassX.composeSignatureDescription(messageName, parmTypes, returnType, true);
    }
}

