/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.lang;

import com.glaivestone.javax.lang.ClassX;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class ConstantType {
    public final int ord;
    public final String name;
    protected static Map<Class<? extends ConstantType>, List<ConstantType>> constantsRegistry = new HashMap<Class<? extends ConstantType>, List<ConstantType>>();
    protected static Map<Class<? extends ConstantType>, Map<String, String>> synonymsRegistry = new HashMap<Class<? extends ConstantType>, Map<String, String>>();

    protected ConstantType(int ordinalValue, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Constant requires a name: " + this.getClass().getName() + "(" + ordinalValue + ")");
        }
        this.ord = ordinalValue;
        this.name = name.intern();
        if (this.isRegisteredType()) {
            this.registerConstant();
        }
    }

    public static ConstantType getConstant(int ordinalValue, Class<? extends ConstantType> constantClass) {
        List<ConstantType> definedConstants = ConstantType.getRegisteredConstants(constantClass);
        if (definedConstants == null) {
            return null;
        }
        for (ConstantType aConstant : definedConstants) {
            if (aConstant.ord != ordinalValue) continue;
            return aConstant;
        }
        return null;
    }

    public static ConstantType getConstant(String name, Class<? extends ConstantType> constantClass) {
        if (name == null) {
            return null;
        }
        ConstantType aConstant = ConstantType.getConstantBasic(name, constantClass);
        if (aConstant == null) {
            aConstant = ConstantType.getConstantFromSynonym(name, constantClass);
        }
        return aConstant;
    }

    protected static ConstantType getConstantBasic(String name, Class<? extends ConstantType> constantClass) {
        List<ConstantType> definedConstants = ConstantType.getRegisteredConstants(constantClass);
        if (definedConstants == null) {
            return null;
        }
        for (ConstantType aConstant : definedConstants) {
            if (!name.equals(aConstant.name)) continue;
            return aConstant;
        }
        return null;
    }

    protected static ConstantType getConstantFromSynonym(String synonym, Class<? extends ConstantType> constantClass) {
        Map<?, ?> synonymMap = ConstantType.getSynonymMap(constantClass);
        if (synonymMap == null) {
            return null;
        }
        String realName = (String)synonymMap.get(synonym);
        return realName != null ? ConstantType.getConstantBasic(realName, constantClass) : null;
    }

    protected static List<ConstantType> getRegisteredConstants(Class<? extends ConstantType> constantClass) {
        return constantsRegistry.get(constantClass);
    }

    protected static void registerConstant(ConstantType aConstant, Class<? extends ConstantType> constantClass) {
        List<ConstantType> allocatedConstants = constantsRegistry.get(constantClass);
        if (allocatedConstants == null) {
            allocatedConstants = new ArrayList<ConstantType>();
            constantsRegistry.put(constantClass, allocatedConstants);
        }
        aConstant.validateConstant(allocatedConstants);
        allocatedConstants.add(aConstant);
    }

    protected static Map<?, ?> getSynonymMap(Class<?> constantClass) {
        return synonymsRegistry.get(constantClass);
    }

    protected static void registerSynonym(String synonym, String constantName, Class<? extends ConstantType> constantClass) {
        Map<String, String> synonymMap = synonymsRegistry.get(constantClass);
        if (synonymMap == null) {
            synonymMap = new HashMap<String, String>();
            synonymsRegistry.put(constantClass, synonymMap);
        }
        synonymMap.put(synonym, constantName);
    }

    protected static void registerSynonyms(String[][] synonymSpecs, Class<? extends ConstantType> constantClass) {
        for (int i = 0; i < synonymSpecs.length; ++i) {
            ConstantType.registerSynonym(synonymSpecs[i][0], synonymSpecs[i][1], constantClass);
        }
    }

    protected static void validateOrdinalConstant(int anOrdinal, ConstantType aConstant) {
        if (anOrdinal != aConstant.ord) {
            throw new IllegalStateException("Incorrect ordinal value constant for " + aConstant.toSimpleConstantName() + " (should be " + aConstant.ord + ")");
        }
    }

    protected boolean hasStrictOrdinalAllocation() {
        return false;
    }

    protected boolean hasStrictRegistryManagement() {
        return true;
    }

    public int intValue() {
        return this.ord;
    }

    protected boolean isRegisteredType() {
        return true;
    }

    protected void registerConstant() {
        ConstantType.registerConstant(this, this.getClass());
    }

    public String toConstantName() {
        return this.toSimpleConstantName();
    }

    public String toDescriptionString() {
        return this.toConstantName() + " (" + this.ord + ")";
    }

    public String toIdentificationString() {
        return this.toQualifiedConstantName() + "(" + this.ord + ")";
    }

    public String toQualifiedConstantName() {
        return this.getClass().getName() + "." + this.name;
    }

    public String toSimpleConstantName() {
        return ClassX.getSimpleName(this.getClass()) + "." + this.name;
    }

    public String toString() {
        return this.toConstantName();
    }

    protected void validateConstant(List<? extends ConstantType> allocatedConstants) {
        if (this.hasStrictOrdinalAllocation() && allocatedConstants.size() > 0) {
            ConstantType lastConstant = allocatedConstants.get(allocatedConstants.size() - 1);
            if (this.ord != lastConstant.ord + 1) {
                throw new IllegalArgumentException("Invalid constant ordinal: " + this.toIdentificationString());
            }
        }
        if (this.hasStrictRegistryManagement()) {
            for (ConstantType constantType : allocatedConstants) {
                if (this.ord == constantType.ord) {
                    throw new IllegalArgumentException("Invalid constant (duplicate ordinal): " + this.toIdentificationString());
                }
                if (!this.name.equals(constantType.name)) continue;
                throw new IllegalArgumentException("Invalid constant (duplicate name): " + this.toIdentificationString());
            }
        }
    }
}

