/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.lang;

import com.glaivestone.javax.lang.ClassX;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ConstantValue<K extends ConstantValue<K>> {
    private static final Class<ConstantValue> THIS_CLASS = ConstantValue.class;
    protected static final int NEXT_ORDINAL = -1;
    protected static final Map<Class<? extends ConstantValue<?>>, ConstantsRegistryEntry> constantsRegistry = new HashMap();
    public final int ord;
    public final String name;

    public static <T extends ConstantValue<T>> T getConstant(int ordinalValue, Class<T> constantType) {
        List<ConstantValue> definedConstants = ConstantValue.getRegisteredConstants(constantType);
        if (definedConstants == null) {
            return null;
        }
        for (ConstantValue aConstant : definedConstants) {
            if (aConstant.ord != ordinalValue) continue;
            return (T)aConstant;
        }
        return null;
    }

    public static <T extends ConstantValue<T>> T getConstant(String name, Class<T> constantType) {
        if (name == null) {
            return null;
        }
        T aConstant = ConstantValue.getConstantFromName(name, constantType);
        if (aConstant == null) {
            aConstant = ConstantValue.getConstantFromSynonym(name, constantType);
        }
        return aConstant;
    }

    protected static <T extends ConstantValue<T>> T getConstantFromName(String name, Class<T> constantType) {
        List<ConstantValue> definedConstants = ConstantValue.getRegisteredConstants(constantType);
        if (definedConstants == null) {
            return null;
        }
        for (ConstantValue aConstant : definedConstants) {
            if (!name.equals(aConstant.name)) continue;
            return (T)aConstant;
        }
        return null;
    }

    protected static <T extends ConstantValue<T>> T getConstantFromSynonym(String synonym, Class<T> constantType) {
        ConstantsRegistryEntry entry = ConstantValue.getRegistryEntry(constantType);
        Map<String, String> synonymMap = entry.synonyms;
        if (synonymMap == null) {
            return null;
        }
        String realName = synonymMap.get(synonym);
        return realName != null ? (T)ConstantValue.getConstantFromName(realName, constantType) : null;
    }

    protected static ConstantsRegistryEntry getRegistryEntry(Class<? extends ConstantValue<?>> constantType) {
        ConstantsRegistryEntry entry = constantsRegistry.get(constantType);
        if (entry == null) {
            entry = new ConstantsRegistryEntry(constantType);
            constantsRegistry.put(entry.constantType, entry);
        }
        return entry;
    }

    public static List<? extends ConstantValue<?>> getConstantValues(Class<? extends ConstantValue<?>> constantType) {
        ConstantsRegistryEntry entry = constantsRegistry.get(constantType);
        return entry != null && entry.constants != null ? entry.constants : null;
    }

    protected static <T extends ConstantValue<T>> List<T> getRegisteredConstants(Class<T> constantType) {
        ConstantsRegistryEntry entry = constantsRegistry.get(constantType);
        return entry != null && entry.constants != null ? entry.constants : null;
    }

    protected static void registerSynonym(String synonym, String constantName, Class<? extends ConstantValue<?>> constantType) {
        ConstantsRegistryEntry entry = ConstantValue.getRegistryEntry(constantType);
        Map<String, String> synonymMap = entry.synonyms;
        if (synonymMap == null) {
            entry.synonyms = synonymMap = new HashMap<String, String>();
        }
        if (entry.constants != null) {
            for (ConstantValue<?> aConstant : entry.constants) {
                if (!aConstant.name.equals(constantName)) continue;
                if (!aConstant.allowSynonyms()) {
                    throw new IllegalArgumentException("Synonyms not allowed for " + constantType.getName());
                }
                synonymMap.put(synonym, constantName);
                return;
            }
        }
        if (entry.constants == null) {
            throw new IllegalArgumentException("No constant " + constantType.getName() + "." + constantName + " defined");
        }
    }

    protected static void registerSynonyms(String[][] synonymSpecs, Class<? extends ConstantValue<?>> constantType) {
        for (String[] spec : synonymSpecs) {
            ConstantValue.registerSynonym(spec[0], spec[1], constantType);
        }
    }

    protected static void validateOrdinalConstant(int anOrdinal, ConstantValue<?> aConstant) {
        if (anOrdinal != aConstant.ord) {
            throw new IllegalStateException("Incorrect ordinal value constant for " + aConstant.toSimpleConstantName() + " (should be " + aConstant.ord + ")");
        }
    }

    @Deprecated
    protected static void validateSubclass(Class<? extends ConstantValue<?>> aClass) {
        if (!ClassX.isProperSubclass(aClass, THIS_CLASS)) {
            throw new IllegalArgumentException("Not a subclass of " + THIS_CLASS.getName() + ": " + aClass.getName());
        }
    }

    @Deprecated
    protected static void validateSubclass(Class<? extends ConstantValue<?>> aClass, Class<? extends ConstantValue<?>> baseClass) {
        if (!ClassX.isProperSubclass(aClass, baseClass)) {
            throw new IllegalArgumentException("Not a subclass of " + baseClass.getName() + ": " + aClass.getName());
        }
    }

    public static <T extends ConstantValue<T>> T valueOf(Class<T> constantType, String name) {
        T result = ConstantValue.getConstant(name, constantType);
        if (result != null) {
            return result;
        }
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        if (!ClassX.isProperSubclass(constantType, THIS_CLASS)) {
            throw new IllegalArgumentException(constantType.getName() + " is not a ConstantValue");
        }
        throw new IllegalArgumentException("No constant " + constantType.getName() + "." + name);
    }

    public static <T extends ConstantValue<T>> List<T> values(Class<T> constantType) {
        List<T> values = ConstantValue.getRegisteredConstants(constantType);
        if (values == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(values);
    }

    protected ConstantValue(String name) {
        this(-1, name);
    }

    protected ConstantValue(int ordinalValue, String name) {
        if (ordinalValue == -1) {
            ConstantsRegistryEntry entry = this.findOrCreateRegistryEntry();
            ordinalValue = entry.nextOrdinal++;
        }
        if (ordinalValue < 0) {
            throw new IllegalArgumentException(String.format("Constant ordinal must be a positive integer: %s (%s, %s)", this.getClass().getName(), ordinalValue, name));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Constant requires a name: %s (%s)", this.getClass().getName(), ordinalValue));
        }
        this.ord = ordinalValue;
        this.name = name.intern();
        if (this.isRegisteredType()) {
            this.registerConstant();
        }
    }

    protected boolean allowSynonyms() {
        return false;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int compareByOrdinal(K other) {
        int ord1 = this.ord;
        int ord2 = ((ConstantValue)other).ord;
        if (ord1 == ord2) {
            return 0;
        }
        return ord1 < ord2 ? -1 : 1;
    }

    public Class<K> constantType() {
        return this.getClass();
    }

    protected ConstantsRegistryEntry findOrCreateRegistryEntry() {
        ConstantsRegistryEntry entry = constantsRegistry.get(this.getClass());
        if (entry == null) {
            entry = new ConstantsRegistryEntry(this.constantType());
            constantsRegistry.put(entry.constantType, entry);
        }
        return entry;
    }

    protected boolean hasStrictOrdinalAllocation() {
        return false;
    }

    protected final boolean hasStrictRegistryManagement() {
        return true;
    }

    public int intValue() {
        return this.ord;
    }

    protected final boolean isRegisteredType() {
        return true;
    }

    public final int ordinal() {
        return this.ord;
    }

    public final String name() {
        return this.name;
    }

    protected void registerConstant() {
        ConstantsRegistryEntry entry = this.findOrCreateRegistryEntry();
        List<ConstantValue<K>> allocatedConstants = entry.constants;
        if (allocatedConstants == null) {
            allocatedConstants = new ArrayList<ConstantValue<K>>();
            entry.constants = allocatedConstants;
        }
        this.validateConstant(allocatedConstants);
        allocatedConstants.add(this);
    }

    public boolean removeConstant() {
        ConstantsRegistryEntry entry = constantsRegistry.get(this.getClass());
        if (entry == null) {
            return false;
        }
        List<ConstantValue<?>> allocatedConstants = entry.constants;
        if (allocatedConstants == null) {
            return false;
        }
        return allocatedConstants.remove(this);
    }

    public String toConstantName() {
        return this.toSimpleConstantName();
    }

    public String toDescriptionString() {
        return this.toConstantName() + " (" + this.ord + ")";
    }

    public String toIdentificationString() {
        return this.toQualifiedConstantName() + "(" + this.ord + ")";
    }

    public String toQualifiedConstantName() {
        return this.getClass().getName() + "." + this.name;
    }

    public String toSimpleConstantName() {
        return this.getClass().getSimpleName() + "." + this.name;
    }

    public String toString() {
        return this.toConstantName();
    }

    protected void validateConstant(List<ConstantValue<K>> allocatedConstants) {
        if (this.hasStrictOrdinalAllocation() && allocatedConstants.size() > 0) {
            ConstantValue<K> lastConstant = allocatedConstants.get(allocatedConstants.size() - 1);
            int nextOrd = lastConstant.ord + 1;
            if (this.ord != nextOrd) {
                throw new IllegalArgumentException(String.format("Invalid constant ordinal: %s (expected %s)", this.toIdentificationString(), nextOrd));
            }
        }
        if (this.hasStrictRegistryManagement()) {
            for (ConstantValue<K> aConstant : allocatedConstants) {
                if (this.ord == aConstant.ord) {
                    throw new IllegalArgumentException(String.format("Invalid constant (duplicate ordinal): %s", this.toIdentificationString()));
                }
                if (!this.name.equals(aConstant.name)) continue;
                throw new IllegalArgumentException(String.format("Invalid constant (duplicate name): %s", this.toIdentificationString()));
            }
        }
    }

    static class ConstantsRegistryEntry {
        Class<? extends ConstantValue<?>> constantType;
        int nextOrdinal = 0;
        List<? extends ConstantValue<?>> constants;
        Map<String, String> synonyms;

        ConstantsRegistryEntry(Class<? extends ConstantValue<?>> constantType) {
            this.constantType = constantType;
        }

        public String toString() {
            return String.format("%s<%s, %s constants, nextOrdinal=%s>", this.getClass().getSimpleName(), this.constantType.getName(), this.constants == null ? 0 : this.constants.size(), this.nextOrdinal);
        }
    }
}

