/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.swing;

import com.glaivestone.javax.swing.SwingServices;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class MessageDialog {
    public static final int RESULT_ACCEPTED = 0;
    public static final int RESULT_REJECTED = 1;
    public static final int RESULT_CANCELLED = 2;
    public static final String DEFAULT_CONFIRMER_TITLE = "Please Confirm";
    public static final String DEFAULT_INFORMATION_NOTIFIER_TITLE = "Information";
    public static final String DEFAULT_WARNING_NOTIFIER_TITLE = "Warning";
    public static final String DEFAULT_ERROR_NOTIFIER_TITLE = "Error";
    public static int multiLineMessageThreshold = 100;
    public static boolean USE_WIDTH_HEURISTIC = true;
    public static boolean TRACE_SIZING = false;

    private MessageDialog() {
    }

    public static Object composeMessageArgument(String message) {
        if (message.length() <= multiLineMessageThreshold && message.indexOf("\n") == -1) {
            return message;
        }
        JTextArea messageTextPane = new JTextArea();
        if (USE_WIDTH_HEURISTIC) {
            int maxLineWidth = MessageDialog.computeMaxLineWidth(message);
            if (TRACE_SIZING) {
                System.out.println("Max line width: " + maxLineWidth + "(nChars=" + message.length() + ")");
            }
            if (maxLineWidth > 40) {
                int columnWidth = MessageDialog.computeColumnWidth(maxLineWidth);
                if (TRACE_SIZING) {
                    System.out.println("Column width: " + columnWidth);
                }
                messageTextPane.setColumns(columnWidth);
            }
        }
        SwingServices.current.applyLabelLookAndFeel(messageTextPane);
        messageTextPane.setText(message);
        return messageTextPane;
    }

    protected static int computeColumnWidth(int maxLineWidth) {
        return maxLineWidth < 120 ? (maxLineWidth < 70 ? 30 : (maxLineWidth < 100 ? 40 : 50)) : 60;
    }

    protected static int computeMaxLineWidth(String message) {
        int nChars = message.length();
        int maxLineLength = 0;
        int indexLastLineBreak = 0;
        int indexLineEnd = -1;
        while ((indexLineEnd = message.indexOf(10, indexLineEnd)) != -1) {
            maxLineLength = Math.max(maxLineLength, indexLineEnd - indexLastLineBreak);
            indexLastLineBreak = indexLineEnd;
            while (indexLineEnd < nChars && message.charAt(indexLineEnd) == '\n') {
                ++indexLineEnd;
            }
        }
        maxLineLength = Math.max(maxLineLength, nChars - indexLastLineBreak);
        return maxLineLength;
    }

    public static boolean confirm(String message, Component client) {
        return MessageDialog.confirm(DEFAULT_CONFIRMER_TITLE, message, client);
    }

    public static boolean confirm(String message, int optionType, Component client) {
        return MessageDialog.confirm(DEFAULT_CONFIRMER_TITLE, message, optionType, client);
    }

    public static boolean confirm(String title, String message, Component client) {
        return MessageDialog.confirm(title, message, 0, client);
    }

    public static boolean confirm(String title, String message, int optionType, Component client) {
        int responseCode = JOptionPane.showConfirmDialog(client, MessageDialog.composeMessageArgument(message), title, 0);
        return responseCode == 0 || responseCode == 0;
    }

    public static int confirmOrCancel(String message, Component client) {
        return MessageDialog.confirmOrCancel(DEFAULT_CONFIRMER_TITLE, message, client);
    }

    public static int confirmOrCancel(String title, String message, Component client) {
        int responseCode = JOptionPane.showConfirmDialog(client, MessageDialog.composeMessageArgument(message), title, 1);
        if (responseCode == -1) {
            responseCode = 2;
        }
        return responseCode;
    }

    public static void displayError(String message, Component client) {
        MessageDialog.displayMessage(DEFAULT_ERROR_NOTIFIER_TITLE, message, 0, client);
    }

    public static void displayError(String title, String message, Component client) {
        MessageDialog.displayMessage(title, message, 0, client);
    }

    public static void displayMessage(String message, Component client) {
        MessageDialog.displayMessage(DEFAULT_INFORMATION_NOTIFIER_TITLE, message, 1, client);
    }

    public static void displayMessage(String title, String message, Component client) {
        MessageDialog.displayMessage(title, message, 1, client);
    }

    public static void displayMessage(String title, String message, int messageType, Component client) {
        JOptionPane.showMessageDialog(client, MessageDialog.composeMessageArgument(message), title, messageType);
    }

    public static void displayWarning(String message, Component client) {
        MessageDialog.displayMessage(DEFAULT_WARNING_NOTIFIER_TITLE, message, 2, client);
    }

    public static void displayWarning(String title, String message, Component client) {
        MessageDialog.displayMessage(title, message, 2, client);
    }
}

