/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.util;

import com.glaivestone.javax.util.EventListenerList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;

public class EventManager {
    protected static final Map<Object, EventListenerList> EMPTY_EVENT_TABLE = Collections.unmodifiableMap(new HashMap());
    protected Map<Object, EventListenerList> eventTable;

    protected void acquireEventTable(EventManager anEventManager) {
        this.setEventTable(anEventManager.eventTable);
        anEventManager.releaseEventTable();
    }

    public synchronized void addFirstListener(EventListener aListener, Object eventType) {
        this.validateListener(aListener, eventType);
        this.getListenersForEdit(eventType).addFirst(aListener);
    }

    public synchronized void addListener(EventListener aListener, Object eventType) {
        this.validateListener(aListener, eventType);
        this.getListenersForEdit(eventType).add(aListener);
    }

    protected Map<Object, EventListenerList> createEventTable() {
        return new HashMap<Object, EventListenerList>();
    }

    public Map<Object, EventListenerList> getEventTable() {
        return this.eventTable == null ? EMPTY_EVENT_TABLE : this.eventTable;
    }

    public Map<Object, EventListenerList> getEventTableForEdit() {
        if (this.eventTable == null) {
            this.setEventTable(this.createEventTable());
        }
        return this.eventTable;
    }

    public EventListener[] getListeners(Object eventType) {
        EventListenerList listenerList = this.getEventTable().get(eventType);
        return listenerList == null ? EventListenerList.getEmptyListenersArray(this.toListenerType(eventType)) : listenerList.getListeners();
    }

    protected EventListenerList getListenersForEdit(Object eventType) {
        EventListenerList listenerList = this.getEventTableForEdit().get(eventType);
        if (listenerList == null) {
            listenerList = new EventListenerList(this.toListenerType(eventType));
            this.getEventTableForEdit().put(eventType, listenerList);
        }
        return listenerList;
    }

    protected boolean isListenerType(Object eventType) {
        return eventType instanceof Class && ((Class)eventType).isInterface() && EventListener.class.isAssignableFrom((Class)eventType);
    }

    protected void releaseEventTable() {
        this.setEventTable(null);
    }

    public synchronized void removeListener(EventListener aListener, Object eventType) {
        EventListenerList listenerList = this.getListenersForEdit(eventType);
        this.validateListener(aListener, eventType);
        listenerList.remove(aListener);
        if (listenerList.size() == 0) {
            this.getEventTableForEdit().remove(eventType);
        }
    }

    protected Class<EventListener> toListenerType(Object eventType) {
        return this.isListenerType(eventType) ? (Class)eventType : EventListenerList.GENERIC_LISTENER_TYPE;
    }

    protected void setEventTable(Map<Object, EventListenerList> eventTable) {
        this.eventTable = eventTable;
    }

    protected void validateListener(EventListener aListener, Class<?> eventType) {
        if (!eventType.isAssignableFrom(aListener.getClass())) {
            throw new IllegalArgumentException("Invalid listener type: " + aListener + " (" + eventType.getName() + " required)");
        }
    }

    protected void validateListener(EventListener aListener, Object eventType) {
        if (this.isListenerType(eventType)) {
            this.validateListener(aListener, (Class)eventType);
        }
    }
}

