/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.mv;

import com.glaivestone.javax.execution.SessionManager;
import com.glaivestone.javax.util.VetoException;
import com.glaivestone.mv.MultipleWindowsSessionControlPolicy;
import com.glaivestone.mv.SessionControlPolicy;
import com.glaivestone.mv.WindowEvent;
import com.glaivestone.mv.WindowEventListener;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UISessionManager
extends SessionManager {
    public static UISessionManager current;
    protected Set<Window> windows;
    protected SessionControlPolicy sessionControlPolicy;
    protected String defaultWindowIconReference;

    protected UISessionManager() {
        this.initWindows();
    }

    public static void installCurrent() {
        if (current instanceof UISessionManager) {
            return;
        }
        new UISessionManager().becomeCurrent();
    }

    protected void acquireSessionControlPolicy(UISessionManager aSessionManager) {
        if (aSessionManager.hasSessionControlPolicy()) {
            this.setSessionControlPolicy(aSessionManager.getSessionControlPolicy());
            aSessionManager.setSessionControlPolicy(null);
        }
    }

    @Override
    protected void acquireSessionSettings(SessionManager aSessionManager) {
        super.acquireSessionSettings(aSessionManager);
        if (aSessionManager != null && aSessionManager instanceof UISessionManager) {
            this.acquireUISessionSettings((UISessionManager)aSessionManager);
        }
    }

    protected void acquireUISessionSettings(UISessionManager aSessionManager) {
        this.acquireWindows(aSessionManager);
        this.acquireSessionControlPolicy(aSessionManager);
        this.setDefaultWindowIconReference(aSessionManager.getDefaultWindowIconReference());
    }

    protected void acquireWindows(UISessionManager aSessionManager) {
        this.windows = aSessionManager.windows;
        aSessionManager.initWindows();
    }

    public void addWindowListener(WindowEventListener aListener) {
        this.addListener(aListener, WindowEventListener.class);
    }

    @Override
    protected void becomeCurrent() {
        super.becomeCurrent();
        current = this;
    }

    public boolean confirmWindowClose(Window aWindow) {
        try {
            this.fireConfirmWindowClose(aWindow);
            return true;
        }
        catch (VetoException ex) {
            return false;
        }
    }

    protected SessionControlPolicy constructDefaultSessionControlPolicy() {
        return new MultipleWindowsSessionControlPolicy();
    }

    protected void fireConfirmWindowClose(Window aWindow) throws VetoException {
        WindowEvent event = new WindowEvent(aWindow, this, true);
        WindowEventListener[] listeners = this.getWindowListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].confirmWindowClose(event);
        }
    }

    protected void fireWindowClosed(Window aWindow) {
        WindowEvent event = new WindowEvent(aWindow, this);
        WindowEventListener[] listeners = this.getWindowListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].windowClosed(event);
        }
        this.getSessionControlPolicy().windowClosed(event);
    }

    protected void fireWindowClosing(Window aWindow) {
        WindowEvent event = new WindowEvent(aWindow, this);
        WindowEventListener[] listeners = this.getWindowListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].windowClosing(event);
        }
    }

    protected void fireWindowOpened(Window aWindow) {
        WindowEvent event = new WindowEvent(aWindow, this);
        WindowEventListener[] listeners = this.getWindowListeners();
        this.getSessionControlPolicy().windowOpened(event);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].windowOpened(event);
        }
    }

    public String getDefaultWindowIconReference() {
        return this.defaultWindowIconReference;
    }

    public Collection<Window> getOpenWindows() {
        return this.windows;
    }

    public SessionControlPolicy getSessionControlPolicy() {
        if (!this.hasSessionControlPolicy()) {
            this.initSessionControlPolicy();
        }
        return this.sessionControlPolicy;
    }

    protected WindowEventListener[] getWindowListeners() {
        return (WindowEventListener[])this.getListeners(WindowEventListener.class);
    }

    public boolean hasOpenWindows() {
        return this.getOpenWindows().size() > 0;
    }

    public boolean hasSessionControlPolicy() {
        return this.sessionControlPolicy != null;
    }

    protected void initSessionControlPolicy() {
        this.setSessionControlPolicy(this.constructDefaultSessionControlPolicy());
    }

    protected void initWindows() {
        this.windows = new HashSet<Window>();
    }

    public boolean isActive() {
        return this.hasOpenWindows();
    }

    public void removeWindowListener(WindowEventListener aListener) {
        this.removeListener(aListener, WindowEventListener.class);
    }

    public void setDefaultWindowIconReference(String anImageResourceReference) {
        this.defaultWindowIconReference = anImageResourceReference;
    }

    public void setSessionControlPolicy(SessionControlPolicy aPolicy) {
        this.sessionControlPolicy = aPolicy;
    }

    public void windowClosed(Window aWindow) {
        boolean wasRemoved = this.windows.remove(aWindow);
        if (!wasRemoved) {
            return;
        }
        this.fireWindowClosed(aWindow);
    }

    public void windowClosing(Window aWindow) {
        this.fireWindowClosing(aWindow);
    }

    public void windowOpened(Window aWindow) {
        boolean wasAdded = this.windows.add(aWindow);
        if (!wasAdded) {
            return;
        }
        this.fireWindowOpened(aWindow);
    }

    static {
        UISessionManager.installCurrent();
    }
}

