/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.mv.swing;

import com.glaivestone.mv.UISessionManager;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SwingUISessionManager
extends UISessionManager {
    public static SwingUISessionManager current;
    public static final LookAndFeel HOST_SYSTEM_LAF;
    public static final LookAndFeel CROSS_PLATFORM_LAF;
    public static final LookAndFeel DEFAULT_LAF;
    protected boolean escapeKeyClosesDialogs;

    protected SwingUISessionManager() {
        this.installLookAndFeel(DEFAULT_LAF);
    }

    public static LookAndFeel getLookAndFeel(String className) {
        try {
            return (LookAndFeel)Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            System.err.println("Could not load LookAndFeel: " + className);
            ex.printStackTrace();
            return null;
        }
    }

    public static void installCurrent() {
        if (UISessionManager.current instanceof SwingUISessionManager) {
            return;
        }
        new SwingUISessionManager().becomeCurrent();
    }

    @Override
    protected void becomeCurrent() {
        super.becomeCurrent();
        current = this;
    }

    public LookAndFeel getCurrentLookAndFeel() {
        return UIManager.getLookAndFeel();
    }

    protected void initDialogEscKeyOption(LookAndFeel aLookAndFeel) {
        this.setEscapeKeyClosesDialogs(aLookAndFeel.getName().equals("Windows"));
    }

    public boolean installCrossPlatformLookAndFeel() {
        return this.installLookAndFeel(CROSS_PLATFORM_LAF);
    }

    public boolean installLookAndFeel(LookAndFeel aLookAndFeel) {
        try {
            UIManager.setLookAndFeel(aLookAndFeel);
        }
        catch (UnsupportedLookAndFeelException ex) {
            System.err.println("LookAndFeelUtilities could not install LookAndFeel: " + aLookAndFeel);
            ex.printStackTrace();
            return false;
        }
        this.initDialogEscKeyOption(aLookAndFeel);
        return true;
    }

    public boolean installLookAndFeel(String className) {
        return this.installLookAndFeel(SwingUISessionManager.getLookAndFeel(className));
    }

    public boolean installHostSystemLookAndFeel() {
        return this.installLookAndFeel(HOST_SYSTEM_LAF);
    }

    public void setEscapeKeyClosesDialogs(boolean escapeKeyClosesDialogs) {
        this.escapeKeyClosesDialogs = escapeKeyClosesDialogs;
    }

    public boolean shouldEscapeKeyCloseDialogWindows() {
        return this.escapeKeyClosesDialogs;
    }

    static {
        HOST_SYSTEM_LAF = SwingUISessionManager.getLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        CROSS_PLATFORM_LAF = SwingUISessionManager.getLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        DEFAULT_LAF = HOST_SYSTEM_LAF;
        SwingUISessionManager.installCurrent();
    }
}

