<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format" >

<!-- PDF scoring report utilities -->

<!--
 ==============================================================================
 == table generation utilities
 ==============================================================================
-->

<!-- generate N empty table cells; default is 1 -->
<xsl:template name="emptyTableCell">
<xsl:param name="count" select="1"/>
	<fo:table-cell><fo:block>
		<!--<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>-->
		<xsl:text> </xsl:text>  <!-- &nbsp; causes FOP to barf?! -->
	</fo:block></fo:table-cell>
	<xsl:if test="$count>1">
		<xsl:call-template name="emptyTableCell">
			<xsl:with-param name="count" select="$count - 1"/>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- generate an empty table row with N columns -->
<xsl:template name="emptyTableRow">
<xsl:param name="nColumns"/>
	<fo:table-row>
	<xsl:call-template name="emptyTableCell">
		<xsl:with-param name="count" select="$nColumns"/>
	</xsl:call-template>
	</fo:table-row>
</xsl:template>

</xsl:stylesheet>
